@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ApiDefinitionInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about the formal API definition for the app.
 * @property url The URL of the API definition.
 */
public data class ApiDefinitionInfoArgs(
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ApiDefinitionInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ApiDefinitionInfoArgs =
        com.pulumi.azurenative.web.inputs.ApiDefinitionInfoArgs.builder()
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiDefinitionInfoArgs].
 */
@PulumiTagMarker
public class ApiDefinitionInfoArgsBuilder internal constructor() {
    private var url: Output<String>? = null

    /**
     * @param value The URL of the API definition.
     */
    @JvmName("bbvirjfdrqakijib")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The URL of the API definition.
     */
    @JvmName("qokwkniiloccakig")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): ApiDefinitionInfoArgs = ApiDefinitionInfoArgs(
        url = url,
    )
}
