@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ApiResourceDefinitionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * API Definitions
 * @property modifiedSwaggerUrl The modified swagger URL
 * @property originalSwaggerUrl The original swagger URL
 */
public data class ApiResourceDefinitionsArgs(
    public val modifiedSwaggerUrl: Output<String>? = null,
    public val originalSwaggerUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ApiResourceDefinitionsArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ApiResourceDefinitionsArgs =
        com.pulumi.azurenative.web.inputs.ApiResourceDefinitionsArgs.builder()
            .modifiedSwaggerUrl(modifiedSwaggerUrl?.applyValue({ args0 -> args0 }))
            .originalSwaggerUrl(originalSwaggerUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiResourceDefinitionsArgs].
 */
@PulumiTagMarker
public class ApiResourceDefinitionsArgsBuilder internal constructor() {
    private var modifiedSwaggerUrl: Output<String>? = null

    private var originalSwaggerUrl: Output<String>? = null

    /**
     * @param value The modified swagger URL
     */
    @JvmName("ddkupekfhbbjltwe")
    public suspend fun modifiedSwaggerUrl(`value`: Output<String>) {
        this.modifiedSwaggerUrl = value
    }

    /**
     * @param value The original swagger URL
     */
    @JvmName("rborrtojaovmjktr")
    public suspend fun originalSwaggerUrl(`value`: Output<String>) {
        this.originalSwaggerUrl = value
    }

    /**
     * @param value The modified swagger URL
     */
    @JvmName("ygdyndrbdqgdhbml")
    public suspend fun modifiedSwaggerUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedSwaggerUrl = mapped
    }

    /**
     * @param value The original swagger URL
     */
    @JvmName("inmqjfqfyewtyigo")
    public suspend fun originalSwaggerUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originalSwaggerUrl = mapped
    }

    internal fun build(): ApiResourceDefinitionsArgs = ApiResourceDefinitionsArgs(
        modifiedSwaggerUrl = modifiedSwaggerUrl,
        originalSwaggerUrl = originalSwaggerUrl,
    )
}
