@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ApplicationLogsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Application logs configuration.
 * @property azureBlobStorage Application logs to blob storage configuration.
 * @property azureTableStorage Application logs to azure table storage configuration.
 * @property fileSystem Application logs to file system configuration.
 */
public data class ApplicationLogsConfigArgs(
    public val azureBlobStorage: Output<AzureBlobStorageApplicationLogsConfigArgs>? = null,
    public val azureTableStorage: Output<AzureTableStorageApplicationLogsConfigArgs>? = null,
    public val fileSystem: Output<FileSystemApplicationLogsConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ApplicationLogsConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ApplicationLogsConfigArgs =
        com.pulumi.azurenative.web.inputs.ApplicationLogsConfigArgs.builder()
            .azureBlobStorage(azureBlobStorage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .azureTableStorage(azureTableStorage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fileSystem(fileSystem?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApplicationLogsConfigArgs].
 */
@PulumiTagMarker
public class ApplicationLogsConfigArgsBuilder internal constructor() {
    private var azureBlobStorage: Output<AzureBlobStorageApplicationLogsConfigArgs>? = null

    private var azureTableStorage: Output<AzureTableStorageApplicationLogsConfigArgs>? = null

    private var fileSystem: Output<FileSystemApplicationLogsConfigArgs>? = null

    /**
     * @param value Application logs to blob storage configuration.
     */
    @JvmName("mntpguepsymcyauw")
    public suspend fun azureBlobStorage(`value`: Output<AzureBlobStorageApplicationLogsConfigArgs>) {
        this.azureBlobStorage = value
    }

    /**
     * @param value Application logs to azure table storage configuration.
     */
    @JvmName("awlaqxlofaymsnvt")
    public suspend
    fun azureTableStorage(`value`: Output<AzureTableStorageApplicationLogsConfigArgs>) {
        this.azureTableStorage = value
    }

    /**
     * @param value Application logs to file system configuration.
     */
    @JvmName("ftqqsrnhyjcdiecq")
    public suspend fun fileSystem(`value`: Output<FileSystemApplicationLogsConfigArgs>) {
        this.fileSystem = value
    }

    /**
     * @param value Application logs to blob storage configuration.
     */
    @JvmName("xwiuipcfctbgsuxe")
    public suspend fun azureBlobStorage(`value`: AzureBlobStorageApplicationLogsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureBlobStorage = mapped
    }

    /**
     * @param argument Application logs to blob storage configuration.
     */
    @JvmName("abdywreuakpxugbx")
    public suspend
    fun azureBlobStorage(argument: suspend AzureBlobStorageApplicationLogsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AzureBlobStorageApplicationLogsConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.azureBlobStorage = mapped
    }

    /**
     * @param value Application logs to azure table storage configuration.
     */
    @JvmName("joaxvpwpnfvfilsl")
    public suspend fun azureTableStorage(`value`: AzureTableStorageApplicationLogsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureTableStorage = mapped
    }

    /**
     * @param argument Application logs to azure table storage configuration.
     */
    @JvmName("csuywrmlxqilisxo")
    public suspend
    fun azureTableStorage(argument: suspend AzureTableStorageApplicationLogsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AzureTableStorageApplicationLogsConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.azureTableStorage = mapped
    }

    /**
     * @param value Application logs to file system configuration.
     */
    @JvmName("mfyoxmsapcgokseo")
    public suspend fun fileSystem(`value`: FileSystemApplicationLogsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystem = mapped
    }

    /**
     * @param argument Application logs to file system configuration.
     */
    @JvmName("kbuwixohwoywauxc")
    public suspend
    fun fileSystem(argument: suspend FileSystemApplicationLogsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FileSystemApplicationLogsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fileSystem = mapped
    }

    internal fun build(): ApplicationLogsConfigArgs = ApplicationLogsConfigArgs(
        azureBlobStorage = azureBlobStorage,
        azureTableStorage = azureTableStorage,
        fileSystem = fileSystem,
    )
}
