@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ArcConfigurationArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.StorageType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property artifactStorageAccessMode
 * @property artifactStorageClassName
 * @property artifactStorageMountPath
 * @property artifactStorageNodeName
 * @property artifactsStorageType
 * @property frontEndServiceConfiguration
 * @property kubeConfig
 */
public data class ArcConfigurationArgs(
    public val artifactStorageAccessMode: Output<String>? = null,
    public val artifactStorageClassName: Output<String>? = null,
    public val artifactStorageMountPath: Output<String>? = null,
    public val artifactStorageNodeName: Output<String>? = null,
    public val artifactsStorageType: Output<StorageType>? = null,
    public val frontEndServiceConfiguration: Output<FrontEndConfigurationArgs>? = null,
    public val kubeConfig: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ArcConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ArcConfigurationArgs =
        com.pulumi.azurenative.web.inputs.ArcConfigurationArgs.builder()
            .artifactStorageAccessMode(artifactStorageAccessMode?.applyValue({ args0 -> args0 }))
            .artifactStorageClassName(artifactStorageClassName?.applyValue({ args0 -> args0 }))
            .artifactStorageMountPath(artifactStorageMountPath?.applyValue({ args0 -> args0 }))
            .artifactStorageNodeName(artifactStorageNodeName?.applyValue({ args0 -> args0 }))
            .artifactsStorageType(
                artifactsStorageType?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .frontEndServiceConfiguration(
                frontEndServiceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .kubeConfig(kubeConfig?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArcConfigurationArgs].
 */
@PulumiTagMarker
public class ArcConfigurationArgsBuilder internal constructor() {
    private var artifactStorageAccessMode: Output<String>? = null

    private var artifactStorageClassName: Output<String>? = null

    private var artifactStorageMountPath: Output<String>? = null

    private var artifactStorageNodeName: Output<String>? = null

    private var artifactsStorageType: Output<StorageType>? = null

    private var frontEndServiceConfiguration: Output<FrontEndConfigurationArgs>? = null

    private var kubeConfig: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("bfbwtapefowyalsn")
    public suspend fun artifactStorageAccessMode(`value`: Output<String>) {
        this.artifactStorageAccessMode = value
    }

    /**
     * @param value
     */
    @JvmName("vfwhtpikhlfgrjsp")
    public suspend fun artifactStorageClassName(`value`: Output<String>) {
        this.artifactStorageClassName = value
    }

    /**
     * @param value
     */
    @JvmName("bmmoguudubxusdma")
    public suspend fun artifactStorageMountPath(`value`: Output<String>) {
        this.artifactStorageMountPath = value
    }

    /**
     * @param value
     */
    @JvmName("nnvaanrqgbemeqcs")
    public suspend fun artifactStorageNodeName(`value`: Output<String>) {
        this.artifactStorageNodeName = value
    }

    /**
     * @param value
     */
    @JvmName("uwhwmwjhrukryfos")
    public suspend fun artifactsStorageType(`value`: Output<StorageType>) {
        this.artifactsStorageType = value
    }

    /**
     * @param value
     */
    @JvmName("telkvhyidycrvuyr")
    public suspend fun frontEndServiceConfiguration(`value`: Output<FrontEndConfigurationArgs>) {
        this.frontEndServiceConfiguration = value
    }

    /**
     * @param value
     */
    @JvmName("mvtseruxaicvatfs")
    public suspend fun kubeConfig(`value`: Output<String>) {
        this.kubeConfig = value
    }

    /**
     * @param value
     */
    @JvmName("jbhueaucqeecvjvm")
    public suspend fun artifactStorageAccessMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactStorageAccessMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("dlkrojgahpyflbtn")
    public suspend fun artifactStorageClassName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactStorageClassName = mapped
    }

    /**
     * @param value
     */
    @JvmName("tdkoisqmhmmshaos")
    public suspend fun artifactStorageMountPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactStorageMountPath = mapped
    }

    /**
     * @param value
     */
    @JvmName("beumrxtnmctvasum")
    public suspend fun artifactStorageNodeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactStorageNodeName = mapped
    }

    /**
     * @param value
     */
    @JvmName("vhmtackygcayixwa")
    public suspend fun artifactsStorageType(`value`: StorageType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactsStorageType = mapped
    }

    /**
     * @param value
     */
    @JvmName("usmjllppitxrwfvp")
    public suspend fun frontEndServiceConfiguration(`value`: FrontEndConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontEndServiceConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("idktdevlnkpyprpq")
    public suspend
    fun frontEndServiceConfiguration(argument: suspend FrontEndConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FrontEndConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.frontEndServiceConfiguration = mapped
    }

    /**
     * @param value
     */
    @JvmName("hynaqopptctywran")
    public suspend fun kubeConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubeConfig = mapped
    }

    internal fun build(): ArcConfigurationArgs = ArcConfigurationArgs(
        artifactStorageAccessMode = artifactStorageAccessMode,
        artifactStorageClassName = artifactStorageClassName,
        artifactStorageMountPath = artifactStorageMountPath,
        artifactStorageNodeName = artifactStorageNodeName,
        artifactsStorageType = artifactsStorageType,
        frontEndServiceConfiguration = frontEndServiceConfiguration,
        kubeConfig = kubeConfig,
    )
}
