@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AutoHealRulesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Rules that can be defined for auto-heal.
 * @property actions Actions to be executed when a rule is triggered.
 * @property triggers Conditions that describe when to execute the auto-heal actions.
 */
public data class AutoHealRulesArgs(
    public val actions: Output<AutoHealActionsArgs>? = null,
    public val triggers: Output<AutoHealTriggersArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AutoHealRulesArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AutoHealRulesArgs =
        com.pulumi.azurenative.web.inputs.AutoHealRulesArgs.builder()
            .actions(actions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .triggers(triggers?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AutoHealRulesArgs].
 */
@PulumiTagMarker
public class AutoHealRulesArgsBuilder internal constructor() {
    private var actions: Output<AutoHealActionsArgs>? = null

    private var triggers: Output<AutoHealTriggersArgs>? = null

    /**
     * @param value Actions to be executed when a rule is triggered.
     */
    @JvmName("mfghiaalfukewxrm")
    public suspend fun actions(`value`: Output<AutoHealActionsArgs>) {
        this.actions = value
    }

    /**
     * @param value Conditions that describe when to execute the auto-heal actions.
     */
    @JvmName("dirgwxbufeorollj")
    public suspend fun triggers(`value`: Output<AutoHealTriggersArgs>) {
        this.triggers = value
    }

    /**
     * @param value Actions to be executed when a rule is triggered.
     */
    @JvmName("mjmjafusxfymrdwh")
    public suspend fun actions(`value`: AutoHealActionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument Actions to be executed when a rule is triggered.
     */
    @JvmName("wjqmuuexundcmsjj")
    public suspend fun actions(argument: suspend AutoHealActionsArgsBuilder.() -> Unit) {
        val toBeMapped = AutoHealActionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param value Conditions that describe when to execute the auto-heal actions.
     */
    @JvmName("scsyilidffbyoglv")
    public suspend fun triggers(`value`: AutoHealTriggersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    /**
     * @param argument Conditions that describe when to execute the auto-heal actions.
     */
    @JvmName("ceracorkelvfwjvf")
    public suspend fun triggers(argument: suspend AutoHealTriggersArgsBuilder.() -> Unit) {
        val toBeMapped = AutoHealTriggersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.triggers = mapped
    }

    internal fun build(): AutoHealRulesArgs = AutoHealRulesArgs(
        actions = actions,
        triggers = triggers,
    )
}
