@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AutoHealTriggersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Triggers for auto-heal.
 * @property privateBytesInKB A rule based on private bytes.
 * @property requests A rule based on total requests.
 * @property slowRequests A rule based on request execution time.
 * @property slowRequestsWithPath A rule based on multiple Slow Requests Rule with path
 * @property statusCodes A rule based on status codes.
 * @property statusCodesRange A rule based on status codes ranges.
 */
public data class AutoHealTriggersArgs(
    public val privateBytesInKB: Output<Int>? = null,
    public val requests: Output<RequestsBasedTriggerArgs>? = null,
    public val slowRequests: Output<SlowRequestsBasedTriggerArgs>? = null,
    public val slowRequestsWithPath: Output<List<SlowRequestsBasedTriggerArgs>>? = null,
    public val statusCodes: Output<List<StatusCodesBasedTriggerArgs>>? = null,
    public val statusCodesRange: Output<List<StatusCodesRangeBasedTriggerArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AutoHealTriggersArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AutoHealTriggersArgs =
        com.pulumi.azurenative.web.inputs.AutoHealTriggersArgs.builder()
            .privateBytesInKB(privateBytesInKB?.applyValue({ args0 -> args0 }))
            .requests(requests?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .slowRequests(slowRequests?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .slowRequestsWithPath(
                slowRequestsWithPath?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .statusCodes(
                statusCodes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .statusCodesRange(
                statusCodesRange?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AutoHealTriggersArgs].
 */
@PulumiTagMarker
public class AutoHealTriggersArgsBuilder internal constructor() {
    private var privateBytesInKB: Output<Int>? = null

    private var requests: Output<RequestsBasedTriggerArgs>? = null

    private var slowRequests: Output<SlowRequestsBasedTriggerArgs>? = null

    private var slowRequestsWithPath: Output<List<SlowRequestsBasedTriggerArgs>>? = null

    private var statusCodes: Output<List<StatusCodesBasedTriggerArgs>>? = null

    private var statusCodesRange: Output<List<StatusCodesRangeBasedTriggerArgs>>? = null

    /**
     * @param value A rule based on private bytes.
     */
    @JvmName("ymjqcqaawbmacrsn")
    public suspend fun privateBytesInKB(`value`: Output<Int>) {
        this.privateBytesInKB = value
    }

    /**
     * @param value A rule based on total requests.
     */
    @JvmName("ikblifjwcneqfkcy")
    public suspend fun requests(`value`: Output<RequestsBasedTriggerArgs>) {
        this.requests = value
    }

    /**
     * @param value A rule based on request execution time.
     */
    @JvmName("qehffoihhajofbmh")
    public suspend fun slowRequests(`value`: Output<SlowRequestsBasedTriggerArgs>) {
        this.slowRequests = value
    }

    /**
     * @param value A rule based on multiple Slow Requests Rule with path
     */
    @JvmName("xwopqxgyijpakuxs")
    public suspend fun slowRequestsWithPath(`value`: Output<List<SlowRequestsBasedTriggerArgs>>) {
        this.slowRequestsWithPath = value
    }

    @JvmName("owysjcqysmboakvr")
    public suspend fun slowRequestsWithPath(vararg values: Output<SlowRequestsBasedTriggerArgs>) {
        this.slowRequestsWithPath = Output.all(values.asList())
    }

    /**
     * @param values A rule based on multiple Slow Requests Rule with path
     */
    @JvmName("iffrciwflijrbqgs")
    public suspend fun slowRequestsWithPath(values: List<Output<SlowRequestsBasedTriggerArgs>>) {
        this.slowRequestsWithPath = Output.all(values)
    }

    /**
     * @param value A rule based on status codes.
     */
    @JvmName("eeqkidufvbjcjusr")
    public suspend fun statusCodes(`value`: Output<List<StatusCodesBasedTriggerArgs>>) {
        this.statusCodes = value
    }

    @JvmName("uhcthgvsxjuatdvv")
    public suspend fun statusCodes(vararg values: Output<StatusCodesBasedTriggerArgs>) {
        this.statusCodes = Output.all(values.asList())
    }

    /**
     * @param values A rule based on status codes.
     */
    @JvmName("ggaufuiqoogksequ")
    public suspend fun statusCodes(values: List<Output<StatusCodesBasedTriggerArgs>>) {
        this.statusCodes = Output.all(values)
    }

    /**
     * @param value A rule based on status codes ranges.
     */
    @JvmName("wgmvyllhvtmgdghm")
    public suspend fun statusCodesRange(`value`: Output<List<StatusCodesRangeBasedTriggerArgs>>) {
        this.statusCodesRange = value
    }

    @JvmName("jcthvjbuobnhtidj")
    public suspend fun statusCodesRange(vararg values: Output<StatusCodesRangeBasedTriggerArgs>) {
        this.statusCodesRange = Output.all(values.asList())
    }

    /**
     * @param values A rule based on status codes ranges.
     */
    @JvmName("kfcoltqcwjbbjevv")
    public suspend fun statusCodesRange(values: List<Output<StatusCodesRangeBasedTriggerArgs>>) {
        this.statusCodesRange = Output.all(values)
    }

    /**
     * @param value A rule based on private bytes.
     */
    @JvmName("fqlsxhpmfwjsucuq")
    public suspend fun privateBytesInKB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateBytesInKB = mapped
    }

    /**
     * @param value A rule based on total requests.
     */
    @JvmName("ocawjngpsaobbsna")
    public suspend fun requests(`value`: RequestsBasedTriggerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    /**
     * @param argument A rule based on total requests.
     */
    @JvmName("qhrqdchorpjtuilu")
    public suspend fun requests(argument: suspend RequestsBasedTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = RequestsBasedTriggerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.requests = mapped
    }

    /**
     * @param value A rule based on request execution time.
     */
    @JvmName("vihrutywlbtdmpjb")
    public suspend fun slowRequests(`value`: SlowRequestsBasedTriggerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slowRequests = mapped
    }

    /**
     * @param argument A rule based on request execution time.
     */
    @JvmName("dektbnvjjcwxcggt")
    public suspend
    fun slowRequests(argument: suspend SlowRequestsBasedTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = SlowRequestsBasedTriggerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.slowRequests = mapped
    }

    /**
     * @param value A rule based on multiple Slow Requests Rule with path
     */
    @JvmName("osxkrifecpojmgij")
    public suspend fun slowRequestsWithPath(`value`: List<SlowRequestsBasedTriggerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slowRequestsWithPath = mapped
    }

    /**
     * @param argument A rule based on multiple Slow Requests Rule with path
     */
    @JvmName("qyuynlbbrwtkstsu")
    public suspend
    fun slowRequestsWithPath(argument: List<suspend SlowRequestsBasedTriggerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SlowRequestsBasedTriggerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slowRequestsWithPath = mapped
    }

    /**
     * @param argument A rule based on multiple Slow Requests Rule with path
     */
    @JvmName("ywogjtsrujfucbkv")
    public suspend fun slowRequestsWithPath(
        vararg
        argument: suspend SlowRequestsBasedTriggerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SlowRequestsBasedTriggerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slowRequestsWithPath = mapped
    }

    /**
     * @param argument A rule based on multiple Slow Requests Rule with path
     */
    @JvmName("dggcjsnjulokuqpo")
    public suspend
    fun slowRequestsWithPath(argument: suspend SlowRequestsBasedTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SlowRequestsBasedTriggerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.slowRequestsWithPath = mapped
    }

    /**
     * @param values A rule based on multiple Slow Requests Rule with path
     */
    @JvmName("bvtsxhflicmyfuoi")
    public suspend fun slowRequestsWithPath(vararg values: SlowRequestsBasedTriggerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slowRequestsWithPath = mapped
    }

    /**
     * @param value A rule based on status codes.
     */
    @JvmName("uiddggcpaxirarvj")
    public suspend fun statusCodes(`value`: List<StatusCodesBasedTriggerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statusCodes = mapped
    }

    /**
     * @param argument A rule based on status codes.
     */
    @JvmName("puffpyhltmictnrg")
    public suspend
    fun statusCodes(argument: List<suspend StatusCodesBasedTriggerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StatusCodesBasedTriggerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statusCodes = mapped
    }

    /**
     * @param argument A rule based on status codes.
     */
    @JvmName("mqcwattnqttsdxel")
    public suspend fun statusCodes(
        vararg
        argument: suspend StatusCodesBasedTriggerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StatusCodesBasedTriggerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statusCodes = mapped
    }

    /**
     * @param argument A rule based on status codes.
     */
    @JvmName("kjtliquspkbhqocl")
    public suspend fun statusCodes(argument: suspend StatusCodesBasedTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            StatusCodesBasedTriggerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.statusCodes = mapped
    }

    /**
     * @param values A rule based on status codes.
     */
    @JvmName("muxxvjsxcnbwcwrd")
    public suspend fun statusCodes(vararg values: StatusCodesBasedTriggerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusCodes = mapped
    }

    /**
     * @param value A rule based on status codes ranges.
     */
    @JvmName("qmrluokyietlqvcy")
    public suspend fun statusCodesRange(`value`: List<StatusCodesRangeBasedTriggerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statusCodesRange = mapped
    }

    /**
     * @param argument A rule based on status codes ranges.
     */
    @JvmName("pytykxbvnetcnltf")
    public suspend
    fun statusCodesRange(argument: List<suspend StatusCodesRangeBasedTriggerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StatusCodesRangeBasedTriggerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statusCodesRange = mapped
    }

    /**
     * @param argument A rule based on status codes ranges.
     */
    @JvmName("tmssapmyqpbjwmkx")
    public suspend fun statusCodesRange(
        vararg
        argument: suspend StatusCodesRangeBasedTriggerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StatusCodesRangeBasedTriggerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statusCodesRange = mapped
    }

    /**
     * @param argument A rule based on status codes ranges.
     */
    @JvmName("vhndejbjhcgjefed")
    public suspend
    fun statusCodesRange(argument: suspend StatusCodesRangeBasedTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            StatusCodesRangeBasedTriggerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.statusCodesRange = mapped
    }

    /**
     * @param values A rule based on status codes ranges.
     */
    @JvmName("qfhjiyvwmvwbbnkd")
    public suspend fun statusCodesRange(vararg values: StatusCodesRangeBasedTriggerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusCodesRange = mapped
    }

    internal fun build(): AutoHealTriggersArgs = AutoHealTriggersArgs(
        privateBytesInKB = privateBytesInKB,
        requests = requests,
        slowRequests = slowRequests,
        slowRequestsWithPath = slowRequestsWithPath,
        statusCodes = statusCodes,
        statusCodesRange = statusCodesRange,
    )
}
