@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AzureStorageInfoValueArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.AzureStorageType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Files or Blob Storage access information value for dictionary storage.
 * @property accessKey Access key for the storage account.
 * @property accountName Name of the storage account.
 * @property mountPath Path to mount the storage within the site's runtime environment.
 * @property shareName Name of the file share (container name, for Blob storage).
 * @property type Type of storage.
 */
public data class AzureStorageInfoValueArgs(
    public val accessKey: Output<String>? = null,
    public val accountName: Output<String>? = null,
    public val mountPath: Output<String>? = null,
    public val shareName: Output<String>? = null,
    public val type: Output<AzureStorageType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AzureStorageInfoValueArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AzureStorageInfoValueArgs =
        com.pulumi.azurenative.web.inputs.AzureStorageInfoValueArgs.builder()
            .accessKey(accessKey?.applyValue({ args0 -> args0 }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .mountPath(mountPath?.applyValue({ args0 -> args0 }))
            .shareName(shareName?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AzureStorageInfoValueArgs].
 */
@PulumiTagMarker
public class AzureStorageInfoValueArgsBuilder internal constructor() {
    private var accessKey: Output<String>? = null

    private var accountName: Output<String>? = null

    private var mountPath: Output<String>? = null

    private var shareName: Output<String>? = null

    private var type: Output<AzureStorageType>? = null

    /**
     * @param value Access key for the storage account.
     */
    @JvmName("spvmkhksmfbobkgq")
    public suspend fun accessKey(`value`: Output<String>) {
        this.accessKey = value
    }

    /**
     * @param value Name of the storage account.
     */
    @JvmName("qhtyrqissbgfuvxb")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Path to mount the storage within the site's runtime environment.
     */
    @JvmName("dcuixfhojttnxeei")
    public suspend fun mountPath(`value`: Output<String>) {
        this.mountPath = value
    }

    /**
     * @param value Name of the file share (container name, for Blob storage).
     */
    @JvmName("inhnmwmwuveardhl")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value Type of storage.
     */
    @JvmName("lwjvkmliccxcikbr")
    public suspend fun type(`value`: Output<AzureStorageType>) {
        this.type = value
    }

    /**
     * @param value Access key for the storage account.
     */
    @JvmName("jmpvnlmyuclavalv")
    public suspend fun accessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKey = mapped
    }

    /**
     * @param value Name of the storage account.
     */
    @JvmName("astkahwgdcchxawa")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Path to mount the storage within the site's runtime environment.
     */
    @JvmName("vhfqqwyhlnhdhufo")
    public suspend fun mountPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountPath = mapped
    }

    /**
     * @param value Name of the file share (container name, for Blob storage).
     */
    @JvmName("uudtamgylqjpkfqu")
    public suspend fun shareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    /**
     * @param value Type of storage.
     */
    @JvmName("dsqromfnydbuyofj")
    public suspend fun type(`value`: AzureStorageType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureStorageInfoValueArgs = AzureStorageInfoValueArgs(
        accessKey = accessKey,
        accountName = accountName,
        mountPath = mountPath,
        shareName = shareName,
        type = type,
    )
}
