@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ConnStringInfoArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.ConnectionStringType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Database connection string information.
 * @property connectionString Connection string value.
 * @property name Name of connection string.
 * @property type Type of database.
 */
public data class ConnStringInfoArgs(
    public val connectionString: Output<String>? = null,
    public val name: Output<String>? = null,
    public val type: Output<ConnectionStringType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ConnStringInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ConnStringInfoArgs =
        com.pulumi.azurenative.web.inputs.ConnStringInfoArgs.builder()
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConnStringInfoArgs].
 */
@PulumiTagMarker
public class ConnStringInfoArgsBuilder internal constructor() {
    private var connectionString: Output<String>? = null

    private var name: Output<String>? = null

    private var type: Output<ConnectionStringType>? = null

    /**
     * @param value Connection string value.
     */
    @JvmName("ftutepqfjrtossvl")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value Name of connection string.
     */
    @JvmName("bwmgnqcrrpusrptx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type of database.
     */
    @JvmName("qllwjggicweejtfs")
    public suspend fun type(`value`: Output<ConnectionStringType>) {
        this.type = value
    }

    /**
     * @param value Connection string value.
     */
    @JvmName("biddoktvojjyvjrm")
    public suspend fun connectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value Name of connection string.
     */
    @JvmName("rjnpavphrkgiwnuh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type of database.
     */
    @JvmName("oxvjofjshrctpqcc")
    public suspend fun type(`value`: ConnectionStringType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ConnStringInfoArgs = ConnStringInfoArgs(
        connectionString = connectionString,
        name = name,
        type = type,
    )
}
