@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ConnectionGatewayDefinitionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property backendUri The URI of the backend
 * @property connectionGatewayInstallation The gateway installation reference
 * @property contactInformation The gateway admin
 * @property description The gateway description
 * @property displayName The gateway display name
 * @property machineName The machine name of the gateway
 * @property status The gateway status
 */
public data class ConnectionGatewayDefinitionPropertiesArgs(
    public val backendUri: Output<String>? = null,
    public val connectionGatewayInstallation: Output<ConnectionGatewayReferenceArgs>? = null,
    public val contactInformation: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val machineName: Output<String>? = null,
    public val status: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ConnectionGatewayDefinitionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ConnectionGatewayDefinitionPropertiesArgs =
        com.pulumi.azurenative.web.inputs.ConnectionGatewayDefinitionPropertiesArgs.builder()
            .backendUri(backendUri?.applyValue({ args0 -> args0 }))
            .connectionGatewayInstallation(
                connectionGatewayInstallation?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .contactInformation(contactInformation?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .machineName(machineName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionGatewayDefinitionPropertiesArgs].
 */
@PulumiTagMarker
public class ConnectionGatewayDefinitionPropertiesArgsBuilder internal constructor() {
    private var backendUri: Output<String>? = null

    private var connectionGatewayInstallation: Output<ConnectionGatewayReferenceArgs>? = null

    private var contactInformation: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var machineName: Output<String>? = null

    private var status: Output<Any>? = null

    /**
     * @param value The URI of the backend
     */
    @JvmName("hldrsuoqkpyvhmlh")
    public suspend fun backendUri(`value`: Output<String>) {
        this.backendUri = value
    }

    /**
     * @param value The gateway installation reference
     */
    @JvmName("vdlaxabbuoviekbf")
    public suspend
    fun connectionGatewayInstallation(`value`: Output<ConnectionGatewayReferenceArgs>) {
        this.connectionGatewayInstallation = value
    }

    /**
     * @param value The gateway admin
     */
    @JvmName("flgvpmyvyalneosh")
    public suspend fun contactInformation(`value`: Output<List<String>>) {
        this.contactInformation = value
    }

    @JvmName("qsetvuavwoxdqnoy")
    public suspend fun contactInformation(vararg values: Output<String>) {
        this.contactInformation = Output.all(values.asList())
    }

    /**
     * @param values The gateway admin
     */
    @JvmName("nfvkvkoglrsmpoxp")
    public suspend fun contactInformation(values: List<Output<String>>) {
        this.contactInformation = Output.all(values)
    }

    /**
     * @param value The gateway description
     */
    @JvmName("acldrsqvqcwtvocw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The gateway display name
     */
    @JvmName("eweqpxqereepjrla")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The machine name of the gateway
     */
    @JvmName("scybcgratemfjsqc")
    public suspend fun machineName(`value`: Output<String>) {
        this.machineName = value
    }

    /**
     * @param value The gateway status
     */
    @JvmName("bnwqhrknhagmxvtq")
    public suspend fun status(`value`: Output<Any>) {
        this.status = value
    }

    /**
     * @param value The URI of the backend
     */
    @JvmName("fkgdxikrlearjmsk")
    public suspend fun backendUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendUri = mapped
    }

    /**
     * @param value The gateway installation reference
     */
    @JvmName("votvukkblxjspmfp")
    public suspend fun connectionGatewayInstallation(`value`: ConnectionGatewayReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionGatewayInstallation = mapped
    }

    /**
     * @param argument The gateway installation reference
     */
    @JvmName("hjqduuwpjjimksod")
    public suspend
    fun connectionGatewayInstallation(argument: suspend ConnectionGatewayReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionGatewayReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectionGatewayInstallation = mapped
    }

    /**
     * @param value The gateway admin
     */
    @JvmName("lasnauphxfldymqr")
    public suspend fun contactInformation(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactInformation = mapped
    }

    /**
     * @param values The gateway admin
     */
    @JvmName("hfqvsddsxvhidsun")
    public suspend fun contactInformation(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactInformation = mapped
    }

    /**
     * @param value The gateway description
     */
    @JvmName("ffqnecplxdrofwlq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The gateway display name
     */
    @JvmName("rtedjcguuvwuklds")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The machine name of the gateway
     */
    @JvmName("yrnapujvkyuiucoe")
    public suspend fun machineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineName = mapped
    }

    /**
     * @param value The gateway status
     */
    @JvmName("otjxtyiatmaodfcu")
    public suspend fun status(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ConnectionGatewayDefinitionPropertiesArgs =
        ConnectionGatewayDefinitionPropertiesArgs(
            backendUri = backendUri,
            connectionGatewayInstallation = connectionGatewayInstallation,
            contactInformation = contactInformation,
            description = description,
            displayName = displayName,
            machineName = machineName,
            status = status,
        )
}
