@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container App container definition.
 * @property args Container start command arguments.
 * @property command Container start command.
 * @property env Container environment variables.
 * @property image Container image tag.
 * @property name Custom container name.
 * @property resources Container resource requirements.
 */
public data class ContainerArgs(
    public val args: Output<List<String>>? = null,
    public val command: Output<List<String>>? = null,
    public val env: Output<List<EnvironmentVarArgs>>? = null,
    public val image: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resources: Output<ContainerResourcesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ContainerArgs =
        com.pulumi.azurenative.web.inputs.ContainerArgs.builder()
            .args(args?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .command(command?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .env(env?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .image(image?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resources(resources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ContainerArgs].
 */
@PulumiTagMarker
public class ContainerArgsBuilder internal constructor() {
    private var args: Output<List<String>>? = null

    private var command: Output<List<String>>? = null

    private var env: Output<List<EnvironmentVarArgs>>? = null

    private var image: Output<String>? = null

    private var name: Output<String>? = null

    private var resources: Output<ContainerResourcesArgs>? = null

    /**
     * @param value Container start command arguments.
     */
    @JvmName("rvinwcoidfyosnus")
    public suspend fun args(`value`: Output<List<String>>) {
        this.args = value
    }

    @JvmName("elruerjxcxcsnwao")
    public suspend fun args(vararg values: Output<String>) {
        this.args = Output.all(values.asList())
    }

    /**
     * @param values Container start command arguments.
     */
    @JvmName("rnopdqjxlgmfetsh")
    public suspend fun args(values: List<Output<String>>) {
        this.args = Output.all(values)
    }

    /**
     * @param value Container start command.
     */
    @JvmName("myvheqofqakadfeh")
    public suspend fun command(`value`: Output<List<String>>) {
        this.command = value
    }

    @JvmName("xijkiqtfuubfffsh")
    public suspend fun command(vararg values: Output<String>) {
        this.command = Output.all(values.asList())
    }

    /**
     * @param values Container start command.
     */
    @JvmName("ncgvimnifkiefhny")
    public suspend fun command(values: List<Output<String>>) {
        this.command = Output.all(values)
    }

    /**
     * @param value Container environment variables.
     */
    @JvmName("wcxvptyxefepcpgg")
    public suspend fun env(`value`: Output<List<EnvironmentVarArgs>>) {
        this.env = value
    }

    @JvmName("bihgbvmcjfvodjkg")
    public suspend fun env(vararg values: Output<EnvironmentVarArgs>) {
        this.env = Output.all(values.asList())
    }

    /**
     * @param values Container environment variables.
     */
    @JvmName("kptwltrngasobntd")
    public suspend fun env(values: List<Output<EnvironmentVarArgs>>) {
        this.env = Output.all(values)
    }

    /**
     * @param value Container image tag.
     */
    @JvmName("vspmfyqvxnyoibot")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value Custom container name.
     */
    @JvmName("qxawpleblhtlpgjf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Container resource requirements.
     */
    @JvmName("iejvjfgfxsagtkaq")
    public suspend fun resources(`value`: Output<ContainerResourcesArgs>) {
        this.resources = value
    }

    /**
     * @param value Container start command arguments.
     */
    @JvmName("wcgcktlerhxtfklv")
    public suspend fun args(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param values Container start command arguments.
     */
    @JvmName("dyqbydgqkfwrybpm")
    public suspend fun args(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value Container start command.
     */
    @JvmName("qexttlqhyvjeyhxs")
    public suspend fun command(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param values Container start command.
     */
    @JvmName("wujdxyedxxlwmilh")
    public suspend fun command(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value Container environment variables.
     */
    @JvmName("snroofseatbmfagi")
    public suspend fun env(`value`: List<EnvironmentVarArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.env = mapped
    }

    /**
     * @param argument Container environment variables.
     */
    @JvmName("wijbuhqajvxlhvsq")
    public suspend fun env(argument: List<suspend EnvironmentVarArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentVarArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.env = mapped
    }

    /**
     * @param argument Container environment variables.
     */
    @JvmName("lwujveggfkpdfkcv")
    public suspend fun env(vararg argument: suspend EnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EnvironmentVarArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.env = mapped
    }

    /**
     * @param argument Container environment variables.
     */
    @JvmName("lvxvdpefcktewtuw")
    public suspend fun env(argument: suspend EnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentVarArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.env = mapped
    }

    /**
     * @param values Container environment variables.
     */
    @JvmName("vgvmckhjjanjrmha")
    public suspend fun env(vararg values: EnvironmentVarArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.env = mapped
    }

    /**
     * @param value Container image tag.
     */
    @JvmName("vhykiieqheijbahw")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value Custom container name.
     */
    @JvmName("jepasteflmowirrs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Container resource requirements.
     */
    @JvmName("dtdatgqybecghfiv")
    public suspend fun resources(`value`: ContainerResourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument Container resource requirements.
     */
    @JvmName("ckuwrewilpndfxby")
    public suspend fun resources(argument: suspend ContainerResourcesArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerResourcesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    internal fun build(): ContainerArgs = ContainerArgs(
        args = args,
        command = command,
        env = env,
        image = image,
        name = name,
        resources = resources,
    )
}
