@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.CorsSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Cross-Origin Resource Sharing (CORS) settings for the app.
 * @property allowedOrigins Gets or sets the list of origins that should be allowed to make cross-origin
 * calls (for example: http://example.com:12345). Use "*" to allow all.
 * @property supportCredentials Gets or sets whether CORS requests with credentials are allowed. See
 * https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
 * for more details.
 */
public data class CorsSettingsArgs(
    public val allowedOrigins: Output<List<String>>? = null,
    public val supportCredentials: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.CorsSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.CorsSettingsArgs =
        com.pulumi.azurenative.web.inputs.CorsSettingsArgs.builder()
            .allowedOrigins(allowedOrigins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .supportCredentials(supportCredentials?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CorsSettingsArgs].
 */
@PulumiTagMarker
public class CorsSettingsArgsBuilder internal constructor() {
    private var allowedOrigins: Output<List<String>>? = null

    private var supportCredentials: Output<Boolean>? = null

    /**
     * @param value Gets or sets the list of origins that should be allowed to make cross-origin
     * calls (for example: http://example.com:12345). Use "*" to allow all.
     */
    @JvmName("apabcuqvaospmkcd")
    public suspend fun allowedOrigins(`value`: Output<List<String>>) {
        this.allowedOrigins = value
    }

    @JvmName("xuppacxwxhkkhahe")
    public suspend fun allowedOrigins(vararg values: Output<String>) {
        this.allowedOrigins = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of origins that should be allowed to make cross-origin
     * calls (for example: http://example.com:12345). Use "*" to allow all.
     */
    @JvmName("miqsdghtujqcvgcb")
    public suspend fun allowedOrigins(values: List<Output<String>>) {
        this.allowedOrigins = Output.all(values)
    }

    /**
     * @param value Gets or sets whether CORS requests with credentials are allowed. See
     * https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
     * for more details.
     */
    @JvmName("eyimmcxhiebivgrl")
    public suspend fun supportCredentials(`value`: Output<Boolean>) {
        this.supportCredentials = value
    }

    /**
     * @param value Gets or sets the list of origins that should be allowed to make cross-origin
     * calls (for example: http://example.com:12345). Use "*" to allow all.
     */
    @JvmName("xhhgmtqrlpuuahpn")
    public suspend fun allowedOrigins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param values Gets or sets the list of origins that should be allowed to make cross-origin
     * calls (for example: http://example.com:12345). Use "*" to allow all.
     */
    @JvmName("ibtdojmxcikyudux")
    public suspend fun allowedOrigins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param value Gets or sets whether CORS requests with credentials are allowed. See
     * https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
     * for more details.
     */
    @JvmName("qrqdxqburwjmgqqw")
    public suspend fun supportCredentials(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportCredentials = mapped
    }

    internal fun build(): CorsSettingsArgs = CorsSettingsArgs(
        allowedOrigins = allowedOrigins,
        supportCredentials = supportCredentials,
    )
}
