@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.CustomApiPropertiesDefinitionArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.ApiType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Custom API properties
 * @property apiDefinitions API Definitions
 * @property apiType The API type
 * @property backendService The API backend service
 * @property brandColor Brand color
 * @property capabilities The custom API capabilities
 * @property connectionParameters Connection parameters
 * @property description The custom API description
 * @property displayName The display name
 * @property iconUri The icon URI
 * @property runtimeUrls Runtime URLs
 * @property swagger The JSON representation of the swagger
 * @property wsdlDefinition The WSDL definition
 */
public data class CustomApiPropertiesDefinitionArgs(
    public val apiDefinitions: Output<ApiResourceDefinitionsArgs>? = null,
    public val apiType: Output<Either<String, ApiType>>? = null,
    public val backendService: Output<ApiResourceBackendServiceArgs>? = null,
    public val brandColor: Output<String>? = null,
    public val capabilities: Output<List<String>>? = null,
    public val connectionParameters: Output<Map<String, ConnectionParameterArgs>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val iconUri: Output<String>? = null,
    public val runtimeUrls: Output<List<String>>? = null,
    public val swagger: Output<Any>? = null,
    public val wsdlDefinition: Output<WsdlDefinitionArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.CustomApiPropertiesDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.CustomApiPropertiesDefinitionArgs =
        com.pulumi.azurenative.web.inputs.CustomApiPropertiesDefinitionArgs.builder()
            .apiDefinitions(apiDefinitions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .apiType(
                apiType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .backendService(backendService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .brandColor(brandColor?.applyValue({ args0 -> args0 }))
            .capabilities(capabilities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectionParameters(
                connectionParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .iconUri(iconUri?.applyValue({ args0 -> args0 }))
            .runtimeUrls(runtimeUrls?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .swagger(swagger?.applyValue({ args0 -> args0 }))
            .wsdlDefinition(
                wsdlDefinition?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomApiPropertiesDefinitionArgs].
 */
@PulumiTagMarker
public class CustomApiPropertiesDefinitionArgsBuilder internal constructor() {
    private var apiDefinitions: Output<ApiResourceDefinitionsArgs>? = null

    private var apiType: Output<Either<String, ApiType>>? = null

    private var backendService: Output<ApiResourceBackendServiceArgs>? = null

    private var brandColor: Output<String>? = null

    private var capabilities: Output<List<String>>? = null

    private var connectionParameters: Output<Map<String, ConnectionParameterArgs>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var iconUri: Output<String>? = null

    private var runtimeUrls: Output<List<String>>? = null

    private var swagger: Output<Any>? = null

    private var wsdlDefinition: Output<WsdlDefinitionArgs>? = null

    /**
     * @param value API Definitions
     */
    @JvmName("cgfexoblcsbemuvw")
    public suspend fun apiDefinitions(`value`: Output<ApiResourceDefinitionsArgs>) {
        this.apiDefinitions = value
    }

    /**
     * @param value The API type
     */
    @JvmName("xcyaxtybigykanng")
    public suspend fun apiType(`value`: Output<Either<String, ApiType>>) {
        this.apiType = value
    }

    /**
     * @param value The API backend service
     */
    @JvmName("ijuighbxkwfvmpyx")
    public suspend fun backendService(`value`: Output<ApiResourceBackendServiceArgs>) {
        this.backendService = value
    }

    /**
     * @param value Brand color
     */
    @JvmName("byofumlpfcpsvcli")
    public suspend fun brandColor(`value`: Output<String>) {
        this.brandColor = value
    }

    /**
     * @param value The custom API capabilities
     */
    @JvmName("otjhrscjsfkjmggc")
    public suspend fun capabilities(`value`: Output<List<String>>) {
        this.capabilities = value
    }

    @JvmName("trhcbrpddejdmjdk")
    public suspend fun capabilities(vararg values: Output<String>) {
        this.capabilities = Output.all(values.asList())
    }

    /**
     * @param values The custom API capabilities
     */
    @JvmName("nclqsfoqfsdnprfr")
    public suspend fun capabilities(values: List<Output<String>>) {
        this.capabilities = Output.all(values)
    }

    /**
     * @param value Connection parameters
     */
    @JvmName("jfoqaajbksmufkry")
    public suspend fun connectionParameters(`value`: Output<Map<String, ConnectionParameterArgs>>) {
        this.connectionParameters = value
    }

    /**
     * @param value The custom API description
     */
    @JvmName("rihvlcdvmtmpwwey")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name
     */
    @JvmName("jixiainjnahufwmc")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The icon URI
     */
    @JvmName("dchdaopbnkxciuii")
    public suspend fun iconUri(`value`: Output<String>) {
        this.iconUri = value
    }

    /**
     * @param value Runtime URLs
     */
    @JvmName("dhirudusvjvlcyxw")
    public suspend fun runtimeUrls(`value`: Output<List<String>>) {
        this.runtimeUrls = value
    }

    @JvmName("vgcbgfmsyllyufaa")
    public suspend fun runtimeUrls(vararg values: Output<String>) {
        this.runtimeUrls = Output.all(values.asList())
    }

    /**
     * @param values Runtime URLs
     */
    @JvmName("bvplbxludwruyxmm")
    public suspend fun runtimeUrls(values: List<Output<String>>) {
        this.runtimeUrls = Output.all(values)
    }

    /**
     * @param value The JSON representation of the swagger
     */
    @JvmName("yhctobhsiijadtwn")
    public suspend fun swagger(`value`: Output<Any>) {
        this.swagger = value
    }

    /**
     * @param value The WSDL definition
     */
    @JvmName("fynkotpdjvtwvnwj")
    public suspend fun wsdlDefinition(`value`: Output<WsdlDefinitionArgs>) {
        this.wsdlDefinition = value
    }

    /**
     * @param value API Definitions
     */
    @JvmName("rebyrorpwyaemfae")
    public suspend fun apiDefinitions(`value`: ApiResourceDefinitionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiDefinitions = mapped
    }

    /**
     * @param argument API Definitions
     */
    @JvmName("pqqhjfkkwpvngssk")
    public suspend
    fun apiDefinitions(argument: suspend ApiResourceDefinitionsArgsBuilder.() -> Unit) {
        val toBeMapped = ApiResourceDefinitionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apiDefinitions = mapped
    }

    /**
     * @param value The API type
     */
    @JvmName("swcvulfuwlkeqypy")
    public suspend fun apiType(`value`: Either<String, ApiType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiType = mapped
    }

    /**
     * @param value The API type
     */
    @JvmName("rhujqmljmmivpvbw")
    public fun apiType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApiType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiType = mapped
    }

    /**
     * @param value The API type
     */
    @JvmName("qdnarudlfrdtqqvt")
    public fun apiType(`value`: ApiType) {
        val toBeMapped = Either.ofRight<String, ApiType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiType = mapped
    }

    /**
     * @param value The API backend service
     */
    @JvmName("hjivasvohwcoribq")
    public suspend fun backendService(`value`: ApiResourceBackendServiceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendService = mapped
    }

    /**
     * @param argument The API backend service
     */
    @JvmName("wiiagwpijnyurqnm")
    public suspend
    fun backendService(argument: suspend ApiResourceBackendServiceArgsBuilder.() -> Unit) {
        val toBeMapped = ApiResourceBackendServiceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendService = mapped
    }

    /**
     * @param value Brand color
     */
    @JvmName("qtsskdkrakrfsbev")
    public suspend fun brandColor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.brandColor = mapped
    }

    /**
     * @param value The custom API capabilities
     */
    @JvmName("xynwttevvgpnndtu")
    public suspend fun capabilities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param values The custom API capabilities
     */
    @JvmName("mcbanuscrwlfpnxh")
    public suspend fun capabilities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param value Connection parameters
     */
    @JvmName("uiswvoxihmxnbpdl")
    public suspend fun connectionParameters(`value`: Map<String, ConnectionParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionParameters = mapped
    }

    /**
     * @param argument Connection parameters
     */
    @JvmName("qnrtbwgjiihwnpji")
    public suspend fun connectionParameters(
        vararg
        argument: Pair<String, suspend ConnectionParameterArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ConnectionParameterArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.connectionParameters = mapped
    }

    /**
     * @param values Connection parameters
     */
    @JvmName("slnsbikwkiqqmfkn")
    public fun connectionParameters(vararg values: Pair<String, ConnectionParameterArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionParameters = mapped
    }

    /**
     * @param value The custom API description
     */
    @JvmName("asnajkknxmvygibk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name
     */
    @JvmName("ucwbrmulaoklsaxp")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The icon URI
     */
    @JvmName("uiuylmnksawbeutr")
    public suspend fun iconUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iconUri = mapped
    }

    /**
     * @param value Runtime URLs
     */
    @JvmName("iddoijjtkkctvqxm")
    public suspend fun runtimeUrls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeUrls = mapped
    }

    /**
     * @param values Runtime URLs
     */
    @JvmName("titivxcvnabrdviq")
    public suspend fun runtimeUrls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runtimeUrls = mapped
    }

    /**
     * @param value The JSON representation of the swagger
     */
    @JvmName("gpfbklmsmtshciii")
    public suspend fun swagger(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.swagger = mapped
    }

    /**
     * @param value The WSDL definition
     */
    @JvmName("ygcvioidfwcufsyg")
    public suspend fun wsdlDefinition(`value`: WsdlDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wsdlDefinition = mapped
    }

    /**
     * @param argument The WSDL definition
     */
    @JvmName("vqqbhpujcndiyvhg")
    public suspend fun wsdlDefinition(argument: suspend WsdlDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = WsdlDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.wsdlDefinition = mapped
    }

    internal fun build(): CustomApiPropertiesDefinitionArgs = CustomApiPropertiesDefinitionArgs(
        apiDefinitions = apiDefinitions,
        apiType = apiType,
        backendService = backendService,
        brandColor = brandColor,
        capabilities = capabilities,
        connectionParameters = connectionParameters,
        description = description,
        displayName = displayName,
        iconUri = iconUri,
        runtimeUrls = runtimeUrls,
        swagger = swagger,
        wsdlDefinition = wsdlDefinition,
    )
}
