@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.CustomDnsSuffixConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Full view of the custom domain suffix configuration for ASEv3.
 * @property certificateUrl The URL referencing the Azure Key Vault certificate secret that should be used as the default SSL/TLS certificate for sites with the custom domain suffix.
 * @property dnsSuffix The default custom domain suffix to use for all sites deployed on the ASE.
 * @property keyVaultReferenceIdentity The user-assigned identity to use for resolving the key vault certificate reference. If not specified, the system-assigned ASE identity will be used if available.
 * @property kind Kind of resource.
 */
public data class CustomDnsSuffixConfigurationArgs(
    public val certificateUrl: Output<String>? = null,
    public val dnsSuffix: Output<String>? = null,
    public val keyVaultReferenceIdentity: Output<String>? = null,
    public val kind: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.CustomDnsSuffixConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.CustomDnsSuffixConfigurationArgs =
        com.pulumi.azurenative.web.inputs.CustomDnsSuffixConfigurationArgs.builder()
            .certificateUrl(certificateUrl?.applyValue({ args0 -> args0 }))
            .dnsSuffix(dnsSuffix?.applyValue({ args0 -> args0 }))
            .keyVaultReferenceIdentity(keyVaultReferenceIdentity?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomDnsSuffixConfigurationArgs].
 */
@PulumiTagMarker
public class CustomDnsSuffixConfigurationArgsBuilder internal constructor() {
    private var certificateUrl: Output<String>? = null

    private var dnsSuffix: Output<String>? = null

    private var keyVaultReferenceIdentity: Output<String>? = null

    private var kind: Output<String>? = null

    /**
     * @param value The URL referencing the Azure Key Vault certificate secret that should be used as the default SSL/TLS certificate for sites with the custom domain suffix.
     */
    @JvmName("rfivawijkadvqfyq")
    public suspend fun certificateUrl(`value`: Output<String>) {
        this.certificateUrl = value
    }

    /**
     * @param value The default custom domain suffix to use for all sites deployed on the ASE.
     */
    @JvmName("ihoqjjhmtxeegmkn")
    public suspend fun dnsSuffix(`value`: Output<String>) {
        this.dnsSuffix = value
    }

    /**
     * @param value The user-assigned identity to use for resolving the key vault certificate reference. If not specified, the system-assigned ASE identity will be used if available.
     */
    @JvmName("plumwrgbcdlnkndo")
    public suspend fun keyVaultReferenceIdentity(`value`: Output<String>) {
        this.keyVaultReferenceIdentity = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("wmiblbpvccykvqpq")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The URL referencing the Azure Key Vault certificate secret that should be used as the default SSL/TLS certificate for sites with the custom domain suffix.
     */
    @JvmName("konhpkveibmueoum")
    public suspend fun certificateUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateUrl = mapped
    }

    /**
     * @param value The default custom domain suffix to use for all sites deployed on the ASE.
     */
    @JvmName("vnmlebekywxhqfpp")
    public suspend fun dnsSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSuffix = mapped
    }

    /**
     * @param value The user-assigned identity to use for resolving the key vault certificate reference. If not specified, the system-assigned ASE identity will be used if available.
     */
    @JvmName("lonkkxrpluedjfqv")
    public suspend fun keyVaultReferenceIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultReferenceIdentity = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("lrfwxvwdlgdybbtq")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    internal fun build(): CustomDnsSuffixConfigurationArgs = CustomDnsSuffixConfigurationArgs(
        certificateUrl = certificateUrl,
        dnsSuffix = dnsSuffix,
        keyVaultReferenceIdentity = keyVaultReferenceIdentity,
        kind = kind,
    )
}
