@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.DatabaseBackupSetting.builder
import com.pulumi.azurenative.web.kotlin.enums.DatabaseType
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Database backup settings.
 * @property connectionString Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new database, the database name inside is the new one.
 * @property connectionStringName Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
 * This is used during restore with overwrite connection strings options.
 * @property databaseType Database type (e.g. SqlAzure / MySql).
 * @property name
 */
public data class DatabaseBackupSetting(
    public val connectionString: String? = null,
    public val connectionStringName: String? = null,
    public val databaseType: Either<String, DatabaseType>,
    public val name: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.DatabaseBackupSetting> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.DatabaseBackupSetting =
        com.pulumi.azurenative.web.inputs.DatabaseBackupSetting.builder()
            .connectionString(connectionString?.let({ args0 -> args0 }))
            .connectionStringName(connectionStringName?.let({ args0 -> args0 }))
            .databaseType(
                databaseType.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabaseBackupSetting].
 */
@PulumiTagMarker
public class DatabaseBackupSettingBuilder internal constructor() {
    private var connectionString: String? = null

    private var connectionStringName: String? = null

    private var databaseType: Either<String, DatabaseType>? = null

    private var name: String? = null

    /**
     * @param value Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new database, the database name inside is the new one.
     */
    @JvmName("pfxaotivfukiqmhf")
    public suspend fun connectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.connectionString = mapped
    }

    /**
     * @param value Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
     * This is used during restore with overwrite connection strings options.
     */
    @JvmName("jihwkgkriygeulri")
    public suspend fun connectionStringName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.connectionStringName = mapped
    }

    /**
     * @param value Database type (e.g. SqlAzure / MySql).
     */
    @JvmName("cvbvwpwlvenefent")
    public suspend fun databaseType(`value`: Either<String, DatabaseType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseType = mapped
    }

    /**
     * @param value Database type (e.g. SqlAzure / MySql).
     */
    @JvmName("qovsuqmkgfveclbq")
    public fun databaseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseType = mapped
    }

    /**
     * @param value Database type (e.g. SqlAzure / MySql).
     */
    @JvmName("fipibqbgeiqomnaf")
    public fun databaseType(`value`: DatabaseType) {
        val toBeMapped = Either.ofRight<String, DatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseType = mapped
    }

    /**
     * @param value
     */
    @JvmName("ishtyvkppgwoxdap")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): DatabaseBackupSetting = DatabaseBackupSetting(
        connectionString = connectionString,
        connectionStringName = connectionStringName,
        databaseType = databaseType ?: throw PulumiNullFieldException("databaseType"),
        name = name,
    )
}
