@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.FileSystemTokenStoreArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration settings of the storage of the tokens if a file system is used.
 * @property directory The directory in which the tokens will be stored.
 */
public data class FileSystemTokenStoreArgs(
    public val directory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.FileSystemTokenStoreArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.FileSystemTokenStoreArgs =
        com.pulumi.azurenative.web.inputs.FileSystemTokenStoreArgs.builder()
            .directory(directory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileSystemTokenStoreArgs].
 */
@PulumiTagMarker
public class FileSystemTokenStoreArgsBuilder internal constructor() {
    private var directory: Output<String>? = null

    /**
     * @param value The directory in which the tokens will be stored.
     */
    @JvmName("pooluwqpgdtygmhh")
    public suspend fun directory(`value`: Output<String>) {
        this.directory = value
    }

    /**
     * @param value The directory in which the tokens will be stored.
     */
    @JvmName("wftdkegrrjhbxtay")
    public suspend fun directory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directory = mapped
    }

    internal fun build(): FileSystemTokenStoreArgs = FileSystemTokenStoreArgs(
        directory = directory,
    )
}
