@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName Connection name
 * @property resourceGroupName The resource group
 * @property subscriptionId Subscription Id
 */
public data class GetConnectionPlainArgs(
    public val connectionName: String,
    public val resourceGroupName: String,
    public val subscriptionId: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetConnectionPlainArgs =
        com.pulumi.azurenative.web.inputs.GetConnectionPlainArgs.builder()
            .connectionName(connectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetConnectionPlainArgsBuilder internal constructor() {
    private var connectionName: String? = null

    private var resourceGroupName: String? = null

    private var subscriptionId: String? = null

    /**
     * @param value Connection name
     */
    @JvmName("ntadcxmfubwqqruy")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionName = mapped
    }

    /**
     * @param value The resource group
     */
    @JvmName("aksutplqgouugmjw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Subscription Id
     */
    @JvmName("nsrdioyrluptefhp")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptionId = mapped
    }

    internal fun build(): GetConnectionPlainArgs = GetConnectionPlainArgs(
        connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        subscriptionId = subscriptionId,
    )
}
