@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetStaticSiteCustomDomainPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName The custom domain name.
 * @property name Name of the static site resource to search in.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetStaticSiteCustomDomainPlainArgs(
    public val domainName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetStaticSiteCustomDomainPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetStaticSiteCustomDomainPlainArgs =
        com.pulumi.azurenative.web.inputs.GetStaticSiteCustomDomainPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStaticSiteCustomDomainPlainArgs].
 */
@PulumiTagMarker
public class GetStaticSiteCustomDomainPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The custom domain name.
     */
    @JvmName("biydpifmlbnudxwl")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value Name of the static site resource to search in.
     */
    @JvmName("vdohgstbmlehgrhw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("gejnwcglrqrbthbf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetStaticSiteCustomDomainPlainArgs = GetStaticSiteCustomDomainPlainArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
