@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetStaticSiteDatabaseConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseConnectionName Name of the database connection.
 * @property name Name of the static site
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetStaticSiteDatabaseConnectionPlainArgs(
    public val databaseConnectionName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetStaticSiteDatabaseConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetStaticSiteDatabaseConnectionPlainArgs =
        com.pulumi.azurenative.web.inputs.GetStaticSiteDatabaseConnectionPlainArgs.builder()
            .databaseConnectionName(databaseConnectionName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStaticSiteDatabaseConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetStaticSiteDatabaseConnectionPlainArgsBuilder internal constructor() {
    private var databaseConnectionName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the database connection.
     */
    @JvmName("kohqgylkmvryuttl")
    public suspend fun databaseConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseConnectionName = mapped
    }

    /**
     * @param value Name of the static site
     */
    @JvmName("icisokehpuqfgdtw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("myiiuoxvbgkcyulo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetStaticSiteDatabaseConnectionPlainArgs =
        GetStaticSiteDatabaseConnectionPlainArgs(
            databaseConnectionName = databaseConnectionName ?: throw
                PulumiNullFieldException("databaseConnectionName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
