@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppDeploymentSlotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id Deployment ID.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API gets a deployment for the production slot.
 */
public data class GetWebAppDeploymentSlotPlainArgs(
    public val id: String,
    public val name: String,
    public val resourceGroupName: String,
    public val slot: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppDeploymentSlotPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppDeploymentSlotPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppDeploymentSlotPlainArgs.builder()
            .id(id.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .slot(slot.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppDeploymentSlotPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppDeploymentSlotPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    private var slot: String? = null

    /**
     * @param value Deployment ID.
     */
    @JvmName("mbafklivtkhewcgx")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("prfaxmmypgvotpwb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ghswqmqvjvgslbfy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API gets a deployment for the production slot.
     */
    @JvmName("yyaooqycrsjpassy")
    public suspend fun slot(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.slot = mapped
    }

    internal fun build(): GetWebAppDeploymentSlotPlainArgs = GetWebAppDeploymentSlotPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        slot = slot ?: throw PulumiNullFieldException("slot"),
    )
}
