@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppHybridConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the web app.
 * @property namespaceName The namespace for this hybrid connection.
 * @property relayName The relay name for this hybrid connection.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetWebAppHybridConnectionPlainArgs(
    public val name: String,
    public val namespaceName: String,
    public val relayName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppHybridConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppHybridConnectionPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppHybridConnectionPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .relayName(relayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppHybridConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppHybridConnectionPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var namespaceName: String? = null

    private var relayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the web app.
     */
    @JvmName("eusjceptivccjqsd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The namespace for this hybrid connection.
     */
    @JvmName("reioymlhbnfqxaxy")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The relay name for this hybrid connection.
     */
    @JvmName("bcoyftuqcodnybsk")
    public suspend fun relayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.relayName = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("dxmvombrfyqinpvp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWebAppHybridConnectionPlainArgs = GetWebAppHybridConnectionPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        relayName = relayName ?: throw PulumiNullFieldException("relayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
