@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppPublicCertificateSlotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the app.
 * @property publicCertificateName Public certificate name.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API the named binding for the production slot.
 */
public data class GetWebAppPublicCertificateSlotPlainArgs(
    public val name: String,
    public val publicCertificateName: String,
    public val resourceGroupName: String,
    public val slot: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppPublicCertificateSlotPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppPublicCertificateSlotPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppPublicCertificateSlotPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .publicCertificateName(publicCertificateName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .slot(slot.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppPublicCertificateSlotPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppPublicCertificateSlotPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var publicCertificateName: String? = null

    private var resourceGroupName: String? = null

    private var slot: String? = null

    /**
     * @param value Name of the app.
     */
    @JvmName("acoukwyjgplqopkc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Public certificate name.
     */
    @JvmName("jliejyshmvfaubcp")
    public suspend fun publicCertificateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.publicCertificateName = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ohtkjidmabpvlucg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API the named binding for the production slot.
     */
    @JvmName("uguxhdwqgtaymkfv")
    public suspend fun slot(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.slot = mapped
    }

    internal fun build(): GetWebAppPublicCertificateSlotPlainArgs =
        GetWebAppPublicCertificateSlotPlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            publicCertificateName = publicCertificateName ?: throw
                PulumiNullFieldException("publicCertificateName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            slot = slot ?: throw PulumiNullFieldException("slot"),
        )
}
