@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppRelayServiceConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property entityName Name of the hybrid connection.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetWebAppRelayServiceConnectionPlainArgs(
    public val entityName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppRelayServiceConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppRelayServiceConnectionPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppRelayServiceConnectionPlainArgs.builder()
            .entityName(entityName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppRelayServiceConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppRelayServiceConnectionPlainArgsBuilder internal constructor() {
    private var entityName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the hybrid connection.
     */
    @JvmName("gydfvgwvaviijbko")
    public suspend fun entityName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.entityName = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("mqntdbmrkbdpalll")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("xtsihbfrqtncmppm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWebAppRelayServiceConnectionPlainArgs =
        GetWebAppRelayServiceConnectionPlainArgs(
            entityName = entityName ?: throw PulumiNullFieldException("entityName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
