@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppSwiftVirtualNetworkConnectionSlotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will get a gateway for the production slot's Virtual Network.
 */
public data class GetWebAppSwiftVirtualNetworkConnectionSlotPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val slot: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppSwiftVirtualNetworkConnectionSlotPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.web.inputs.GetWebAppSwiftVirtualNetworkConnectionSlotPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppSwiftVirtualNetworkConnectionSlotPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .slot(slot.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppSwiftVirtualNetworkConnectionSlotPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppSwiftVirtualNetworkConnectionSlotPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var slot: String? = null

    /**
     * @param value Name of the app.
     */
    @JvmName("wnogqlysqfxvbtqj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("tkrawytqlslxyyjq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will get a gateway for the production slot's Virtual Network.
     */
    @JvmName("obccpcfmmpqkycqv")
    public suspend fun slot(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.slot = mapped
    }

    internal fun build(): GetWebAppSwiftVirtualNetworkConnectionSlotPlainArgs =
        GetWebAppSwiftVirtualNetworkConnectionSlotPlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            slot = slot ?: throw PulumiNullFieldException("slot"),
        )
}
