@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppVnetConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property vnetName Name of the virtual network.
 */
public data class GetWebAppVnetConnectionPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val vnetName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppVnetConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppVnetConnectionPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppVnetConnectionPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vnetName(vnetName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppVnetConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppVnetConnectionPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var vnetName: String? = null

    /**
     * @param value Name of the app.
     */
    @JvmName("fgqymtyocyibflcc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("xfhtmjwkduatuxpo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the virtual network.
     */
    @JvmName("tekguatipaqrwgdc")
    public suspend fun vnetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vnetName = mapped
    }

    internal fun build(): GetWebAppVnetConnectionPlainArgs = GetWebAppVnetConnectionPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vnetName = vnetName ?: throw PulumiNullFieldException("vnetName"),
    )
}
