@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GlobalValidationArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.UnauthenticatedClientActionV2
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The configuration settings that determines the validation flow of users using App Service Authentication/Authorization.
 * @property excludedPaths The paths for which unauthenticated flow would not be redirected to the login page.
 * @property redirectToProvider The default authentication provider to use when multiple providers are configured.
 * This setting is only needed if multiple providers are configured and the unauthenticated client
 * action is set to "RedirectToLoginPage".
 * @property requireAuthentication <code>true</code> if the authentication flow is required any request is made; otherwise, <code>false</code>.
 * @property unauthenticatedClientAction The action to take when an unauthenticated client attempts to access the app.
 */
public data class GlobalValidationArgs(
    public val excludedPaths: Output<List<String>>? = null,
    public val redirectToProvider: Output<String>? = null,
    public val requireAuthentication: Output<Boolean>? = null,
    public val unauthenticatedClientAction: Output<UnauthenticatedClientActionV2>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GlobalValidationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GlobalValidationArgs =
        com.pulumi.azurenative.web.inputs.GlobalValidationArgs.builder()
            .excludedPaths(excludedPaths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .redirectToProvider(redirectToProvider?.applyValue({ args0 -> args0 }))
            .requireAuthentication(requireAuthentication?.applyValue({ args0 -> args0 }))
            .unauthenticatedClientAction(
                unauthenticatedClientAction?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [GlobalValidationArgs].
 */
@PulumiTagMarker
public class GlobalValidationArgsBuilder internal constructor() {
    private var excludedPaths: Output<List<String>>? = null

    private var redirectToProvider: Output<String>? = null

    private var requireAuthentication: Output<Boolean>? = null

    private var unauthenticatedClientAction: Output<UnauthenticatedClientActionV2>? = null

    /**
     * @param value The paths for which unauthenticated flow would not be redirected to the login page.
     */
    @JvmName("gyuirxgticgxynsh")
    public suspend fun excludedPaths(`value`: Output<List<String>>) {
        this.excludedPaths = value
    }

    @JvmName("lbhwbhyavsxcqmff")
    public suspend fun excludedPaths(vararg values: Output<String>) {
        this.excludedPaths = Output.all(values.asList())
    }

    /**
     * @param values The paths for which unauthenticated flow would not be redirected to the login page.
     */
    @JvmName("vbvsbbitdouxyvag")
    public suspend fun excludedPaths(values: List<Output<String>>) {
        this.excludedPaths = Output.all(values)
    }

    /**
     * @param value The default authentication provider to use when multiple providers are configured.
     * This setting is only needed if multiple providers are configured and the unauthenticated client
     * action is set to "RedirectToLoginPage".
     */
    @JvmName("gromnddqnbjhwemj")
    public suspend fun redirectToProvider(`value`: Output<String>) {
        this.redirectToProvider = value
    }

    /**
     * @param value <code>true</code> if the authentication flow is required any request is made; otherwise, <code>false</code>.
     */
    @JvmName("naonxfpclpbseyfr")
    public suspend fun requireAuthentication(`value`: Output<Boolean>) {
        this.requireAuthentication = value
    }

    /**
     * @param value The action to take when an unauthenticated client attempts to access the app.
     */
    @JvmName("cladfdkqicmtyrav")
    public suspend fun unauthenticatedClientAction(`value`: Output<UnauthenticatedClientActionV2>) {
        this.unauthenticatedClientAction = value
    }

    /**
     * @param value The paths for which unauthenticated flow would not be redirected to the login page.
     */
    @JvmName("jelkuijqtvitahyq")
    public suspend fun excludedPaths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedPaths = mapped
    }

    /**
     * @param values The paths for which unauthenticated flow would not be redirected to the login page.
     */
    @JvmName("jlmjaqdplftvwnem")
    public suspend fun excludedPaths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedPaths = mapped
    }

    /**
     * @param value The default authentication provider to use when multiple providers are configured.
     * This setting is only needed if multiple providers are configured and the unauthenticated client
     * action is set to "RedirectToLoginPage".
     */
    @JvmName("qtqdanpygkldgqjg")
    public suspend fun redirectToProvider(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectToProvider = mapped
    }

    /**
     * @param value <code>true</code> if the authentication flow is required any request is made; otherwise, <code>false</code>.
     */
    @JvmName("uyhjuaskyrgddvad")
    public suspend fun requireAuthentication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireAuthentication = mapped
    }

    /**
     * @param value The action to take when an unauthenticated client attempts to access the app.
     */
    @JvmName("rrebvmldkelljbbs")
    public suspend fun unauthenticatedClientAction(`value`: UnauthenticatedClientActionV2?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unauthenticatedClientAction = mapped
    }

    internal fun build(): GlobalValidationArgs = GlobalValidationArgs(
        excludedPaths = excludedPaths,
        redirectToProvider = redirectToProvider,
        requireAuthentication = requireAuthentication,
        unauthenticatedClientAction = unauthenticatedClientAction,
    )
}
