@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.HostNameSslStateArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.HostType
import com.pulumi.azurenative.web.kotlin.enums.SslState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SSL-enabled hostname.
 * @property hostType Indicates whether the hostname is a standard or repository hostname.
 * @property name Hostname.
 * @property sslState SSL type.
 * @property thumbprint SSL certificate thumbprint.
 * @property toUpdate Set to <code>true</code> to update existing hostname.
 * @property virtualIP Virtual IP address assigned to the hostname if IP based SSL is enabled.
 */
public data class HostNameSslStateArgs(
    public val hostType: Output<HostType>? = null,
    public val name: Output<String>? = null,
    public val sslState: Output<SslState>? = null,
    public val thumbprint: Output<String>? = null,
    public val toUpdate: Output<Boolean>? = null,
    public val virtualIP: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.HostNameSslStateArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.HostNameSslStateArgs =
        com.pulumi.azurenative.web.inputs.HostNameSslStateArgs.builder()
            .hostType(hostType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .sslState(sslState?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .thumbprint(thumbprint?.applyValue({ args0 -> args0 }))
            .toUpdate(toUpdate?.applyValue({ args0 -> args0 }))
            .virtualIP(virtualIP?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HostNameSslStateArgs].
 */
@PulumiTagMarker
public class HostNameSslStateArgsBuilder internal constructor() {
    private var hostType: Output<HostType>? = null

    private var name: Output<String>? = null

    private var sslState: Output<SslState>? = null

    private var thumbprint: Output<String>? = null

    private var toUpdate: Output<Boolean>? = null

    private var virtualIP: Output<String>? = null

    /**
     * @param value Indicates whether the hostname is a standard or repository hostname.
     */
    @JvmName("gmutjrgbsknejika")
    public suspend fun hostType(`value`: Output<HostType>) {
        this.hostType = value
    }

    /**
     * @param value Hostname.
     */
    @JvmName("naedgsslkedvhgwj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value SSL type.
     */
    @JvmName("alxqvvmflckikjna")
    public suspend fun sslState(`value`: Output<SslState>) {
        this.sslState = value
    }

    /**
     * @param value SSL certificate thumbprint.
     */
    @JvmName("vnpchqwwffyvkxuy")
    public suspend fun thumbprint(`value`: Output<String>) {
        this.thumbprint = value
    }

    /**
     * @param value Set to <code>true</code> to update existing hostname.
     */
    @JvmName("xsellemoqpylquwv")
    public suspend fun toUpdate(`value`: Output<Boolean>) {
        this.toUpdate = value
    }

    /**
     * @param value Virtual IP address assigned to the hostname if IP based SSL is enabled.
     */
    @JvmName("crkflbscwgsoqduu")
    public suspend fun virtualIP(`value`: Output<String>) {
        this.virtualIP = value
    }

    /**
     * @param value Indicates whether the hostname is a standard or repository hostname.
     */
    @JvmName("byixfcfeipoeijnx")
    public suspend fun hostType(`value`: HostType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostType = mapped
    }

    /**
     * @param value Hostname.
     */
    @JvmName("nlwafgsmodnpuawq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value SSL type.
     */
    @JvmName("thsmoxukstmrynov")
    public suspend fun sslState(`value`: SslState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslState = mapped
    }

    /**
     * @param value SSL certificate thumbprint.
     */
    @JvmName("rmacxdwntchxmbil")
    public suspend fun thumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbprint = mapped
    }

    /**
     * @param value Set to <code>true</code> to update existing hostname.
     */
    @JvmName("irmkfniwrugyyafi")
    public suspend fun toUpdate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toUpdate = mapped
    }

    /**
     * @param value Virtual IP address assigned to the hostname if IP based SSL is enabled.
     */
    @JvmName("kqathtevtvtaspgc")
    public suspend fun virtualIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualIP = mapped
    }

    internal fun build(): HostNameSslStateArgs = HostNameSslStateArgs(
        hostType = hostType,
        name = name,
        sslState = sslState,
        thumbprint = thumbprint,
        toUpdate = toUpdate,
        virtualIP = virtualIP,
    )
}
