@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ListConnectionConsentLinksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName Connection name
 * @property parameters Collection of resources
 * @property resourceGroupName The resource group
 * @property subscriptionId Subscription Id
 */
public data class ListConnectionConsentLinksPlainArgs(
    public val connectionName: String,
    public val parameters: List<ConsentLinkParameterDefinition>? = null,
    public val resourceGroupName: String,
    public val subscriptionId: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ListConnectionConsentLinksPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ListConnectionConsentLinksPlainArgs =
        com.pulumi.azurenative.web.inputs.ListConnectionConsentLinksPlainArgs.builder()
            .connectionName(connectionName.let({ args0 -> args0 }))
            .parameters(
                parameters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListConnectionConsentLinksPlainArgs].
 */
@PulumiTagMarker
public class ListConnectionConsentLinksPlainArgsBuilder internal constructor() {
    private var connectionName: String? = null

    private var parameters: List<ConsentLinkParameterDefinition>? = null

    private var resourceGroupName: String? = null

    private var subscriptionId: String? = null

    /**
     * @param value Connection name
     */
    @JvmName("ylrnyjpqghldotwi")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionName = mapped
    }

    /**
     * @param value Collection of resources
     */
    @JvmName("qyccnndstewpjfcn")
    public suspend fun parameters(`value`: List<ConsentLinkParameterDefinition>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.parameters = mapped
    }

    /**
     * @param argument Collection of resources
     */
    @JvmName("vblguusbfgtmrfnf")
    public suspend
    fun parameters(argument: List<suspend ConsentLinkParameterDefinitionBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConsentLinkParameterDefinitionBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.parameters = mapped
    }

    /**
     * @param argument Collection of resources
     */
    @JvmName("gqnpgyibvyqotxnn")
    public suspend fun parameters(
        vararg
        argument: suspend ConsentLinkParameterDefinitionBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConsentLinkParameterDefinitionBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.parameters = mapped
    }

    /**
     * @param argument Collection of resources
     */
    @JvmName("ouvoufonfdrjipya")
    public suspend
    fun parameters(argument: suspend ConsentLinkParameterDefinitionBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConsentLinkParameterDefinitionBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.parameters = mapped
    }

    /**
     * @param values Collection of resources
     */
    @JvmName("affcenxnsmjtmeim")
    public suspend fun parameters(vararg values: ConsentLinkParameterDefinition) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parameters = mapped
    }

    /**
     * @param value The resource group
     */
    @JvmName("lekkduhnbrduuypc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Subscription Id
     */
    @JvmName("ufovlacsrqccqldg")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptionId = mapped
    }

    internal fun build(): ListConnectionConsentLinksPlainArgs = ListConnectionConsentLinksPlainArgs(
        connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
        parameters = parameters,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        subscriptionId = subscriptionId,
    )
}
