@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ListStaticSiteUsersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authprovider The auth provider for the users.
 * @property name Name of the static site.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class ListStaticSiteUsersPlainArgs(
    public val authprovider: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ListStaticSiteUsersPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ListStaticSiteUsersPlainArgs =
        com.pulumi.azurenative.web.inputs.ListStaticSiteUsersPlainArgs.builder()
            .authprovider(authprovider.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListStaticSiteUsersPlainArgs].
 */
@PulumiTagMarker
public class ListStaticSiteUsersPlainArgsBuilder internal constructor() {
    private var authprovider: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The auth provider for the users.
     */
    @JvmName("hdjjrjuisrmiepof")
    public suspend fun authprovider(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authprovider = mapped
    }

    /**
     * @param value Name of the static site.
     */
    @JvmName("kegpeeiqiqmeajfk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("hpsbuhsewaeqeidm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListStaticSiteUsersPlainArgs = ListStaticSiteUsersPlainArgs(
        authprovider = authprovider ?: throw PulumiNullFieldException("authprovider"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
