@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ListWebAppBackupStatusSecretsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property backupId ID of backup.
 * @property backupName Name of the backup.
 * @property backupSchedule Schedule for the backup if it is executed periodically.
 * @property databases Databases included in the backup.
 * @property enabled True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled.
 * @property kind Kind of resource.
 * @property name Name of web app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property storageAccountUrl SAS URL to the container.
 */
public data class ListWebAppBackupStatusSecretsPlainArgs(
    public val backupId: String,
    public val backupName: String? = null,
    public val backupSchedule: BackupSchedule? = null,
    public val databases: List<DatabaseBackupSetting>? = null,
    public val enabled: Boolean? = null,
    public val kind: String? = null,
    public val name: String,
    public val resourceGroupName: String,
    public val storageAccountUrl: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ListWebAppBackupStatusSecretsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ListWebAppBackupStatusSecretsPlainArgs =
        com.pulumi.azurenative.web.inputs.ListWebAppBackupStatusSecretsPlainArgs.builder()
            .backupId(backupId.let({ args0 -> args0 }))
            .backupName(backupName?.let({ args0 -> args0 }))
            .backupSchedule(backupSchedule?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .databases(databases?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .enabled(enabled?.let({ args0 -> args0 }))
            .kind(kind?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageAccountUrl(storageAccountUrl.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWebAppBackupStatusSecretsPlainArgs].
 */
@PulumiTagMarker
public class ListWebAppBackupStatusSecretsPlainArgsBuilder internal constructor() {
    private var backupId: String? = null

    private var backupName: String? = null

    private var backupSchedule: BackupSchedule? = null

    private var databases: List<DatabaseBackupSetting>? = null

    private var enabled: Boolean? = null

    private var kind: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    private var storageAccountUrl: String? = null

    /**
     * @param value ID of backup.
     */
    @JvmName("bwgrjyyifsfusxim")
    public suspend fun backupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.backupId = mapped
    }

    /**
     * @param value Name of the backup.
     */
    @JvmName("ggfychxtvbjodgif")
    public suspend fun backupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.backupName = mapped
    }

    /**
     * @param value Schedule for the backup if it is executed periodically.
     */
    @JvmName("mjwoxqxcbcbmgcwg")
    public suspend fun backupSchedule(`value`: BackupSchedule?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.backupSchedule = mapped
    }

    /**
     * @param argument Schedule for the backup if it is executed periodically.
     */
    @JvmName("hmesuxqmocjnmbfp")
    public suspend fun backupSchedule(argument: suspend BackupScheduleBuilder.() -> Unit) {
        val toBeMapped = BackupScheduleBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.backupSchedule = mapped
    }

    /**
     * @param value Databases included in the backup.
     */
    @JvmName("hnvfpvhywqsbvysp")
    public suspend fun databases(`value`: List<DatabaseBackupSetting>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.databases = mapped
    }

    /**
     * @param argument Databases included in the backup.
     */
    @JvmName("ohwabghokyntjrqg")
    public suspend fun databases(argument: List<suspend DatabaseBackupSettingBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DatabaseBackupSettingBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.databases = mapped
    }

    /**
     * @param argument Databases included in the backup.
     */
    @JvmName("lbmjdqsfwvvklkkc")
    public suspend fun databases(vararg argument: suspend DatabaseBackupSettingBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DatabaseBackupSettingBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.databases = mapped
    }

    /**
     * @param argument Databases included in the backup.
     */
    @JvmName("hidmrciunynlivqi")
    public suspend fun databases(argument: suspend DatabaseBackupSettingBuilder.() -> Unit) {
        val toBeMapped = listOf(DatabaseBackupSettingBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.databases = mapped
    }

    /**
     * @param values Databases included in the backup.
     */
    @JvmName("hmksmnaqulaxoqpc")
    public suspend fun databases(vararg values: DatabaseBackupSetting) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databases = mapped
    }

    /**
     * @param value True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled.
     */
    @JvmName("uppqyljweooiupul")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enabled = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("edveyxyyjeqdkgos")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.kind = mapped
    }

    /**
     * @param value Name of web app.
     */
    @JvmName("uelsjcskjvfjmjlp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("qibwjumnrinnmfqd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SAS URL to the container.
     */
    @JvmName("xulxyakpqeqlxybt")
    public suspend fun storageAccountUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageAccountUrl = mapped
    }

    internal fun build(): ListWebAppBackupStatusSecretsPlainArgs =
        ListWebAppBackupStatusSecretsPlainArgs(
            backupId = backupId ?: throw PulumiNullFieldException("backupId"),
            backupName = backupName,
            backupSchedule = backupSchedule,
            databases = databases,
            enabled = enabled,
            kind = kind,
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            storageAccountUrl = storageAccountUrl ?: throw PulumiNullFieldException("storageAccountUrl"),
        )
}
