@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.PushSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Push settings for the App.
 * @property dynamicTagsJson Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
 * @property isPushEnabled Gets or sets a flag indicating whether the Push endpoint is enabled.
 * @property kind Kind of resource.
 * @property tagWhitelistJson Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
 * @property tagsRequiringAuth Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
 * Tags can consist of alphanumeric characters and the following:
 * '_', '@', '#', '.', ':', '-'.
 * Validation should be performed at the PushRequestHandler.
 */
public data class PushSettingsArgs(
    public val dynamicTagsJson: Output<String>? = null,
    public val isPushEnabled: Output<Boolean>,
    public val kind: Output<String>? = null,
    public val tagWhitelistJson: Output<String>? = null,
    public val tagsRequiringAuth: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.PushSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.PushSettingsArgs =
        com.pulumi.azurenative.web.inputs.PushSettingsArgs.builder()
            .dynamicTagsJson(dynamicTagsJson?.applyValue({ args0 -> args0 }))
            .isPushEnabled(isPushEnabled.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .tagWhitelistJson(tagWhitelistJson?.applyValue({ args0 -> args0 }))
            .tagsRequiringAuth(tagsRequiringAuth?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PushSettingsArgs].
 */
@PulumiTagMarker
public class PushSettingsArgsBuilder internal constructor() {
    private var dynamicTagsJson: Output<String>? = null

    private var isPushEnabled: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var tagWhitelistJson: Output<String>? = null

    private var tagsRequiringAuth: Output<String>? = null

    /**
     * @param value Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
     */
    @JvmName("nagooiuxovhhsfai")
    public suspend fun dynamicTagsJson(`value`: Output<String>) {
        this.dynamicTagsJson = value
    }

    /**
     * @param value Gets or sets a flag indicating whether the Push endpoint is enabled.
     */
    @JvmName("uwtwoaxtbulsvssi")
    public suspend fun isPushEnabled(`value`: Output<Boolean>) {
        this.isPushEnabled = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("iqmipcscafgqcuyv")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
     */
    @JvmName("jxlgbsjkndwrklyu")
    public suspend fun tagWhitelistJson(`value`: Output<String>) {
        this.tagWhitelistJson = value
    }

    /**
     * @param value Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
     * Tags can consist of alphanumeric characters and the following:
     * '_', '@', '#', '.', ':', '-'.
     * Validation should be performed at the PushRequestHandler.
     */
    @JvmName("fnoqowtokgjtburi")
    public suspend fun tagsRequiringAuth(`value`: Output<String>) {
        this.tagsRequiringAuth = value
    }

    /**
     * @param value Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
     */
    @JvmName("mvsoioflhmuvhtan")
    public suspend fun dynamicTagsJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamicTagsJson = mapped
    }

    /**
     * @param value Gets or sets a flag indicating whether the Push endpoint is enabled.
     */
    @JvmName("rygduvpdqholuyim")
    public suspend fun isPushEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isPushEnabled = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("jahkakmkfbvolkdd")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
     */
    @JvmName("xvebbbfedkoosaho")
    public suspend fun tagWhitelistJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagWhitelistJson = mapped
    }

    /**
     * @param value Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
     * Tags can consist of alphanumeric characters and the following:
     * '_', '@', '#', '.', ':', '-'.
     * Validation should be performed at the PushRequestHandler.
     */
    @JvmName("ryjlvydegyewgkrw")
    public suspend fun tagsRequiringAuth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagsRequiringAuth = mapped
    }

    internal fun build(): PushSettingsArgs = PushSettingsArgs(
        dynamicTagsJson = dynamicTagsJson,
        isPushEnabled = isPushEnabled ?: throw PulumiNullFieldException("isPushEnabled"),
        kind = kind,
        tagWhitelistJson = tagWhitelistJson,
        tagsRequiringAuth = tagsRequiringAuth,
    )
}
