@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.RampUpRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually change routing % based on performance.
 * @property actionHostName Hostname of a slot to which the traffic will be redirected if decided to. E.g. myapp-stage.azurewebsites.net.
 * @property changeDecisionCallbackUrl Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified. See TiPCallback site extension for the scaffold and contracts.
 * https://www.siteextensions.net/packages/TiPCallback/
 * @property changeIntervalInMinutes Specifies interval in minutes to reevaluate ReroutePercentage.
 * @property changeStep In auto ramp up scenario this is the step to add/remove from <code>ReroutePercentage</code> until it reaches \n<code>MinReroutePercentage</code> or
 * <code>MaxReroutePercentage</code>. Site metrics are checked every N minutes specified in <code>ChangeIntervalInMinutes</code>.\nCustom decision algorithm
 * can be provided in TiPCallback site extension which URL can be specified in <code>ChangeDecisionCallbackUrl</code>.
 * @property maxReroutePercentage Specifies upper boundary below which ReroutePercentage will stay.
 * @property minReroutePercentage Specifies lower boundary above which ReroutePercentage will stay.
 * @property name Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
 * @property reroutePercentage Percentage of the traffic which will be redirected to <code>ActionHostName</code>.
 */
public data class RampUpRuleArgs(
    public val actionHostName: Output<String>? = null,
    public val changeDecisionCallbackUrl: Output<String>? = null,
    public val changeIntervalInMinutes: Output<Int>? = null,
    public val changeStep: Output<Double>? = null,
    public val maxReroutePercentage: Output<Double>? = null,
    public val minReroutePercentage: Output<Double>? = null,
    public val name: Output<String>? = null,
    public val reroutePercentage: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.RampUpRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.RampUpRuleArgs =
        com.pulumi.azurenative.web.inputs.RampUpRuleArgs.builder()
            .actionHostName(actionHostName?.applyValue({ args0 -> args0 }))
            .changeDecisionCallbackUrl(changeDecisionCallbackUrl?.applyValue({ args0 -> args0 }))
            .changeIntervalInMinutes(changeIntervalInMinutes?.applyValue({ args0 -> args0 }))
            .changeStep(changeStep?.applyValue({ args0 -> args0 }))
            .maxReroutePercentage(maxReroutePercentage?.applyValue({ args0 -> args0 }))
            .minReroutePercentage(minReroutePercentage?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .reroutePercentage(reroutePercentage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RampUpRuleArgs].
 */
@PulumiTagMarker
public class RampUpRuleArgsBuilder internal constructor() {
    private var actionHostName: Output<String>? = null

    private var changeDecisionCallbackUrl: Output<String>? = null

    private var changeIntervalInMinutes: Output<Int>? = null

    private var changeStep: Output<Double>? = null

    private var maxReroutePercentage: Output<Double>? = null

    private var minReroutePercentage: Output<Double>? = null

    private var name: Output<String>? = null

    private var reroutePercentage: Output<Double>? = null

    /**
     * @param value Hostname of a slot to which the traffic will be redirected if decided to. E.g. myapp-stage.azurewebsites.net.
     */
    @JvmName("xkhujpanlpswyxip")
    public suspend fun actionHostName(`value`: Output<String>) {
        this.actionHostName = value
    }

    /**
     * @param value Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified. See TiPCallback site extension for the scaffold and contracts.
     * https://www.siteextensions.net/packages/TiPCallback/
     */
    @JvmName("nkdckxvumbhddsbt")
    public suspend fun changeDecisionCallbackUrl(`value`: Output<String>) {
        this.changeDecisionCallbackUrl = value
    }

    /**
     * @param value Specifies interval in minutes to reevaluate ReroutePercentage.
     */
    @JvmName("dqaegxyhtmmngrxl")
    public suspend fun changeIntervalInMinutes(`value`: Output<Int>) {
        this.changeIntervalInMinutes = value
    }

    /**
     * @param value In auto ramp up scenario this is the step to add/remove from <code>ReroutePercentage</code> until it reaches \n<code>MinReroutePercentage</code> or
     * <code>MaxReroutePercentage</code>. Site metrics are checked every N minutes specified in <code>ChangeIntervalInMinutes</code>.\nCustom decision algorithm
     * can be provided in TiPCallback site extension which URL can be specified in <code>ChangeDecisionCallbackUrl</code>.
     */
    @JvmName("ocgtsyomcloknysx")
    public suspend fun changeStep(`value`: Output<Double>) {
        this.changeStep = value
    }

    /**
     * @param value Specifies upper boundary below which ReroutePercentage will stay.
     */
    @JvmName("cdarnrngmhqriktk")
    public suspend fun maxReroutePercentage(`value`: Output<Double>) {
        this.maxReroutePercentage = value
    }

    /**
     * @param value Specifies lower boundary above which ReroutePercentage will stay.
     */
    @JvmName("bnnbrulxqtvkfjkc")
    public suspend fun minReroutePercentage(`value`: Output<Double>) {
        this.minReroutePercentage = value
    }

    /**
     * @param value Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
     */
    @JvmName("fjbereepaldesxge")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Percentage of the traffic which will be redirected to <code>ActionHostName</code>.
     */
    @JvmName("bulhpvvyndgjhjop")
    public suspend fun reroutePercentage(`value`: Output<Double>) {
        this.reroutePercentage = value
    }

    /**
     * @param value Hostname of a slot to which the traffic will be redirected if decided to. E.g. myapp-stage.azurewebsites.net.
     */
    @JvmName("gwfkugljiursukec")
    public suspend fun actionHostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionHostName = mapped
    }

    /**
     * @param value Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified. See TiPCallback site extension for the scaffold and contracts.
     * https://www.siteextensions.net/packages/TiPCallback/
     */
    @JvmName("aehabbpkewnkmhel")
    public suspend fun changeDecisionCallbackUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changeDecisionCallbackUrl = mapped
    }

    /**
     * @param value Specifies interval in minutes to reevaluate ReroutePercentage.
     */
    @JvmName("jkxwtreqarixuuyg")
    public suspend fun changeIntervalInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changeIntervalInMinutes = mapped
    }

    /**
     * @param value In auto ramp up scenario this is the step to add/remove from <code>ReroutePercentage</code> until it reaches \n<code>MinReroutePercentage</code> or
     * <code>MaxReroutePercentage</code>. Site metrics are checked every N minutes specified in <code>ChangeIntervalInMinutes</code>.\nCustom decision algorithm
     * can be provided in TiPCallback site extension which URL can be specified in <code>ChangeDecisionCallbackUrl</code>.
     */
    @JvmName("gdvyfvbeqawvekmy")
    public suspend fun changeStep(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changeStep = mapped
    }

    /**
     * @param value Specifies upper boundary below which ReroutePercentage will stay.
     */
    @JvmName("scqjmauswjmuvsyq")
    public suspend fun maxReroutePercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxReroutePercentage = mapped
    }

    /**
     * @param value Specifies lower boundary above which ReroutePercentage will stay.
     */
    @JvmName("kqlauyodainlaktp")
    public suspend fun minReroutePercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minReroutePercentage = mapped
    }

    /**
     * @param value Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
     */
    @JvmName("iwcqonpmkfpfrbtn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Percentage of the traffic which will be redirected to <code>ActionHostName</code>.
     */
    @JvmName("pfdqvxxsntvtrsmb")
    public suspend fun reroutePercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reroutePercentage = mapped
    }

    internal fun build(): RampUpRuleArgs = RampUpRuleArgs(
        actionHostName = actionHostName,
        changeDecisionCallbackUrl = changeDecisionCallbackUrl,
        changeIntervalInMinutes = changeIntervalInMinutes,
        changeStep = changeStep,
        maxReroutePercentage = maxReroutePercentage,
        minReroutePercentage = minReroutePercentage,
        name = name,
        reroutePercentage = reroutePercentage,
    )
}
