@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.RegistryCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Container App Private Registry
 * @property passwordSecretRef The name of the Secret that contains the registry login password
 * @property server Container Registry Server
 * @property username Container Registry Username
 */
public data class RegistryCredentialsArgs(
    public val passwordSecretRef: Output<String>? = null,
    public val server: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.RegistryCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.RegistryCredentialsArgs =
        com.pulumi.azurenative.web.inputs.RegistryCredentialsArgs.builder()
            .passwordSecretRef(passwordSecretRef?.applyValue({ args0 -> args0 }))
            .server(server?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryCredentialsArgs].
 */
@PulumiTagMarker
public class RegistryCredentialsArgsBuilder internal constructor() {
    private var passwordSecretRef: Output<String>? = null

    private var server: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The name of the Secret that contains the registry login password
     */
    @JvmName("vfsnqqtdynodgkgj")
    public suspend fun passwordSecretRef(`value`: Output<String>) {
        this.passwordSecretRef = value
    }

    /**
     * @param value Container Registry Server
     */
    @JvmName("tjpvdnbyugpgwycs")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value Container Registry Username
     */
    @JvmName("swmevivcuywsnhsu")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The name of the Secret that contains the registry login password
     */
    @JvmName("qhbyogfqkbnbkttk")
    public suspend fun passwordSecretRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordSecretRef = mapped
    }

    /**
     * @param value Container Registry Server
     */
    @JvmName("fsqgrjiiafxbkltl")
    public suspend fun server(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value Container Registry Username
     */
    @JvmName("inqaswkrmqkasjfc")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): RegistryCredentialsArgs = RegistryCredentialsArgs(
        passwordSecretRef = passwordSecretRef,
        server = server,
        username = username,
    )
}
