@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ScaleRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Container App container scaling rule.
 * @property azureQueue Azure Queue based scaling.
 * @property custom Custom scale rule.
 * @property http HTTP requests based scaling.
 * @property name Scale Rule Name
 */
public data class ScaleRuleArgs(
    public val azureQueue: Output<QueueScaleRuleArgs>? = null,
    public val custom: Output<CustomScaleRuleArgs>? = null,
    public val http: Output<HttpScaleRuleArgs>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ScaleRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ScaleRuleArgs =
        com.pulumi.azurenative.web.inputs.ScaleRuleArgs.builder()
            .azureQueue(azureQueue?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .custom(custom?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .http(http?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScaleRuleArgs].
 */
@PulumiTagMarker
public class ScaleRuleArgsBuilder internal constructor() {
    private var azureQueue: Output<QueueScaleRuleArgs>? = null

    private var custom: Output<CustomScaleRuleArgs>? = null

    private var http: Output<HttpScaleRuleArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Azure Queue based scaling.
     */
    @JvmName("rehdonjkgmxdfmpa")
    public suspend fun azureQueue(`value`: Output<QueueScaleRuleArgs>) {
        this.azureQueue = value
    }

    /**
     * @param value Custom scale rule.
     */
    @JvmName("yeojqypokcieuanb")
    public suspend fun custom(`value`: Output<CustomScaleRuleArgs>) {
        this.custom = value
    }

    /**
     * @param value HTTP requests based scaling.
     */
    @JvmName("thlithmtcfbtcjef")
    public suspend fun http(`value`: Output<HttpScaleRuleArgs>) {
        this.http = value
    }

    /**
     * @param value Scale Rule Name
     */
    @JvmName("ryfphxqynoubhudt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Azure Queue based scaling.
     */
    @JvmName("tbepkmjrwsvxokap")
    public suspend fun azureQueue(`value`: QueueScaleRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureQueue = mapped
    }

    /**
     * @param argument Azure Queue based scaling.
     */
    @JvmName("ryldrlmkrhlnuorn")
    public suspend fun azureQueue(argument: suspend QueueScaleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = QueueScaleRuleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureQueue = mapped
    }

    /**
     * @param value Custom scale rule.
     */
    @JvmName("winksbdbhpsmwkld")
    public suspend fun custom(`value`: CustomScaleRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.custom = mapped
    }

    /**
     * @param argument Custom scale rule.
     */
    @JvmName("msrvqlyrgewvjgga")
    public suspend fun custom(argument: suspend CustomScaleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = CustomScaleRuleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.custom = mapped
    }

    /**
     * @param value HTTP requests based scaling.
     */
    @JvmName("himdbunemxjiuxyd")
    public suspend fun http(`value`: HttpScaleRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http = mapped
    }

    /**
     * @param argument HTTP requests based scaling.
     */
    @JvmName("xgyktuvmpxtrjaof")
    public suspend fun http(argument: suspend HttpScaleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = HttpScaleRuleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.http = mapped
    }

    /**
     * @param value Scale Rule Name
     */
    @JvmName("fotkiauxnlgddkoq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ScaleRuleArgs = ScaleRuleArgs(
        azureQueue = azureQueue,
        custom = custom,
        http = http,
        name = name,
    )
}
