@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.StaticSiteTemplateOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Template Options for the static site.
 * @property description Description of the newly generated repository.
 * @property isPrivate Whether or not the newly generated repository is a private repository. Defaults to false (i.e. public).
 * @property owner Owner of the newly generated repository.
 * @property repositoryName Name of the newly generated repository.
 * @property templateRepositoryUrl URL of the template repository. The newly generated repository will be based on this one.
 */
public data class StaticSiteTemplateOptionsArgs(
    public val description: Output<String>? = null,
    public val isPrivate: Output<Boolean>? = null,
    public val owner: Output<String>? = null,
    public val repositoryName: Output<String>? = null,
    public val templateRepositoryUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.StaticSiteTemplateOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.StaticSiteTemplateOptionsArgs =
        com.pulumi.azurenative.web.inputs.StaticSiteTemplateOptionsArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .isPrivate(isPrivate?.applyValue({ args0 -> args0 }))
            .owner(owner?.applyValue({ args0 -> args0 }))
            .repositoryName(repositoryName?.applyValue({ args0 -> args0 }))
            .templateRepositoryUrl(templateRepositoryUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StaticSiteTemplateOptionsArgs].
 */
@PulumiTagMarker
public class StaticSiteTemplateOptionsArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var isPrivate: Output<Boolean>? = null

    private var owner: Output<String>? = null

    private var repositoryName: Output<String>? = null

    private var templateRepositoryUrl: Output<String>? = null

    /**
     * @param value Description of the newly generated repository.
     */
    @JvmName("eiexmnjijoyyocud")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether or not the newly generated repository is a private repository. Defaults to false (i.e. public).
     */
    @JvmName("pjkgbacunhcxkunw")
    public suspend fun isPrivate(`value`: Output<Boolean>) {
        this.isPrivate = value
    }

    /**
     * @param value Owner of the newly generated repository.
     */
    @JvmName("rxbioixtnwbdtxpu")
    public suspend fun owner(`value`: Output<String>) {
        this.owner = value
    }

    /**
     * @param value Name of the newly generated repository.
     */
    @JvmName("sdmwaovmowilbscy")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value URL of the template repository. The newly generated repository will be based on this one.
     */
    @JvmName("keqqfrhawmxweoga")
    public suspend fun templateRepositoryUrl(`value`: Output<String>) {
        this.templateRepositoryUrl = value
    }

    /**
     * @param value Description of the newly generated repository.
     */
    @JvmName("tsnuljabcvttrgkc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether or not the newly generated repository is a private repository. Defaults to false (i.e. public).
     */
    @JvmName("jprdgsngcjcispqp")
    public suspend fun isPrivate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPrivate = mapped
    }

    /**
     * @param value Owner of the newly generated repository.
     */
    @JvmName("biqgswukxjfsdvig")
    public suspend fun owner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    /**
     * @param value Name of the newly generated repository.
     */
    @JvmName("yakltnwqrvwagbha")
    public suspend fun repositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    /**
     * @param value URL of the template repository. The newly generated repository will be based on this one.
     */
    @JvmName("jrlkrtpjscjkwuib")
    public suspend fun templateRepositoryUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateRepositoryUrl = mapped
    }

    internal fun build(): StaticSiteTemplateOptionsArgs = StaticSiteTemplateOptionsArgs(
        description = description,
        isPrivate = isPrivate,
        owner = owner,
        repositoryName = repositoryName,
        templateRepositoryUrl = templateRepositoryUrl,
    )
}
