@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the platform of App Service Authentication/Authorization.
 * @property configFilePath The path of the config file containing auth settings if they come from a file.
 * If the path is relative, base will the site's root directory.
 * @property enabled <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
 * @property runtimeVersion The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
 * The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
 */
public data class AuthPlatformResponse(
    public val configFilePath: String? = null,
    public val enabled: Boolean? = null,
    public val runtimeVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.AuthPlatformResponse):
            AuthPlatformResponse = AuthPlatformResponse(
            configFilePath = javaType.configFilePath().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            runtimeVersion = javaType.runtimeVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
