@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The configuration settings of the Azure Active directory provider.
 * @property enabled <code>false</code> if the Azure Active Directory provider should not be enabled despite the set registration; otherwise, <code>true</code>.
 * @property isAutoProvisioned Gets a value indicating whether the Azure AD configuration was auto-provisioned using 1st party tooling.
 * This is an internal flag primarily intended to support the Azure Management Portal. Users should not
 * read or write to this property.
 * @property login The configuration settings of the Azure Active Directory login flow.
 * @property registration The configuration settings of the Azure Active Directory app registration.
 * @property validation The configuration settings of the Azure Active Directory token validation flow.
 */
public data class AzureActiveDirectoryResponse(
    public val enabled: Boolean? = null,
    public val isAutoProvisioned: Boolean? = null,
    public val login: AzureActiveDirectoryLoginResponse? = null,
    public val registration: AzureActiveDirectoryRegistrationResponse? = null,
    public val validation: AzureActiveDirectoryValidationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.AzureActiveDirectoryResponse):
            AzureActiveDirectoryResponse = AzureActiveDirectoryResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            isAutoProvisioned = javaType.isAutoProvisioned().map({ args0 -> args0 }).orElse(null),
            login = javaType.login().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.AzureActiveDirectoryLoginResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            registration = javaType.registration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.AzureActiveDirectoryRegistrationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            validation = javaType.validation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.AzureActiveDirectoryValidationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
