@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Backup description.
 * @property backupId Id of the backup.
 * @property blobName Name of the blob which contains data for this backup.
 * @property correlationId Unique correlation identifier. Please use this along with the timestamp while communicating with Azure support.
 * @property created Timestamp of the backup creation.
 * @property databases List of databases included in the backup.
 * @property finishedTimeStamp Timestamp when this backup finished.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property lastRestoreTimeStamp Timestamp of a last restore operation which used this backup.
 * @property log Details regarding this backup. Might contain an error message.
 * @property name Resource Name.
 * @property scheduled True if this backup has been created due to a schedule being triggered.
 * @property sizeInBytes Size of the backup in bytes.
 * @property status Backup status.
 * @property storageAccountUrl SAS URL for the storage account container which contains this backup.
 * @property type Resource type.
 * @property websiteSizeInBytes Size of the original web app which has been backed up.
 */
public data class BackupItemResponse(
    public val backupId: Int,
    public val blobName: String,
    public val correlationId: String,
    public val created: String,
    public val databases: List<DatabaseBackupSettingResponse>,
    public val finishedTimeStamp: String,
    public val id: String,
    public val kind: String? = null,
    public val lastRestoreTimeStamp: String,
    public val log: String,
    public val name: String,
    public val scheduled: Boolean,
    public val sizeInBytes: Double,
    public val status: String,
    public val storageAccountUrl: String,
    public val type: String,
    public val websiteSizeInBytes: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.BackupItemResponse):
            BackupItemResponse = BackupItemResponse(
            backupId = javaType.backupId(),
            blobName = javaType.blobName(),
            correlationId = javaType.correlationId(),
            created = javaType.created(),
            databases = javaType.databases().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.DatabaseBackupSettingResponse.Companion.toKotlin(args0)
                })
            }),
            finishedTimeStamp = javaType.finishedTimeStamp(),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            lastRestoreTimeStamp = javaType.lastRestoreTimeStamp(),
            log = javaType.log(),
            name = javaType.name(),
            scheduled = javaType.scheduled(),
            sizeInBytes = javaType.sizeInBytes(),
            status = javaType.status(),
            storageAccountUrl = javaType.storageAccountUrl(),
            type = javaType.type(),
            websiteSizeInBytes = javaType.websiteSizeInBytes(),
        )
    }
}
