@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the storage of the tokens if blob storage is used.
 * @property sasUrlSettingName The name of the app setting containing the SAS URL of the blob storage containing the tokens.
 */
public data class BlobStorageTokenStoreResponse(
    public val sasUrlSettingName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.BlobStorageTokenStoreResponse):
            BlobStorageTokenStoreResponse = BlobStorageTokenStoreResponse(
            sasUrlSettingName = javaType.sasUrlSettingName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
