@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Non versioned Container App configuration properties that define the mutable settings of a Container app
 * @property activeRevisionsMode ActiveRevisionsMode controls how active revisions are handled for the Container app:
 * <list><item>Multiple: multiple revisions can be active. If no value if provided, this is the default</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode</item></list>
 * @property ingress Ingress configurations.
 * @property registries Collection of private container registry credentials for containers used by the Container app
 * @property secrets Collection of secrets used by a Container app
 */
public data class ConfigurationResponse(
    public val activeRevisionsMode: String? = null,
    public val ingress: IngressResponse? = null,
    public val registries: List<RegistryCredentialsResponse>? = null,
    public val secrets: List<SecretResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ConfigurationResponse):
            ConfigurationResponse = ConfigurationResponse(
            activeRevisionsMode = javaType.activeRevisionsMode().map({ args0 -> args0 }).orElse(null),
            ingress = javaType.ingress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.IngressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            registries = javaType.registries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.RegistryCredentialsResponse.Companion.toKotlin(args0)
                })
            }),
            secrets = javaType.secrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.SecretResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
