@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The gateway installation reference
 * @property id Resource reference id
 * @property location Resource reference location
 * @property name Resource reference name
 * @property type Resource reference type
 */
public data class ConnectionGatewayReferenceResponse(
    public val id: String? = null,
    public val location: String? = null,
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ConnectionGatewayReferenceResponse):
            ConnectionGatewayReferenceResponse = ConnectionGatewayReferenceResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
