@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Custom API properties
 * @property apiDefinitions API Definitions
 * @property apiType The API type
 * @property backendService The API backend service
 * @property brandColor Brand color
 * @property capabilities The custom API capabilities
 * @property connectionParameters Connection parameters
 * @property description The custom API description
 * @property displayName The display name
 * @property iconUri The icon URI
 * @property runtimeUrls Runtime URLs
 * @property swagger The JSON representation of the swagger
 * @property wsdlDefinition The WSDL definition
 */
public data class CustomApiPropertiesDefinitionResponse(
    public val apiDefinitions: ApiResourceDefinitionsResponse? = null,
    public val apiType: String? = null,
    public val backendService: ApiResourceBackendServiceResponse? = null,
    public val brandColor: String? = null,
    public val capabilities: List<String>? = null,
    public val connectionParameters: Map<String, ConnectionParameterResponse>? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val iconUri: String? = null,
    public val runtimeUrls: List<String>? = null,
    public val swagger: Any? = null,
    public val wsdlDefinition: WsdlDefinitionResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.CustomApiPropertiesDefinitionResponse):
            CustomApiPropertiesDefinitionResponse = CustomApiPropertiesDefinitionResponse(
            apiDefinitions = javaType.apiDefinitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ApiResourceDefinitionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            apiType = javaType.apiType().map({ args0 -> args0 }).orElse(null),
            backendService = javaType.backendService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ApiResourceBackendServiceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            brandColor = javaType.brandColor().map({ args0 -> args0 }).orElse(null),
            capabilities = javaType.capabilities().map({ args0 -> args0 }),
            connectionParameters = javaType.connectionParameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.web.kotlin.outputs.ConnectionParameterResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            iconUri = javaType.iconUri().map({ args0 -> args0 }).orElse(null),
            runtimeUrls = javaType.runtimeUrls().map({ args0 -> args0 }),
            swagger = javaType.swagger().map({ args0 -> args0 }).orElse(null),
            wsdlDefinition = javaType.wsdlDefinition().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.WsdlDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
