@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Full view of the custom domain suffix configuration for ASEv3.
 * @property certificateUrl The URL referencing the Azure Key Vault certificate secret that should be used as the default SSL/TLS certificate for sites with the custom domain suffix.
 * @property dnsSuffix The default custom domain suffix to use for all sites deployed on the ASE.
 * @property id Resource Id.
 * @property keyVaultReferenceIdentity The user-assigned identity to use for resolving the key vault certificate reference. If not specified, the system-assigned ASE identity will be used if available.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property provisioningDetails
 * @property provisioningState
 * @property type Resource type.
 */
public data class CustomDnsSuffixConfigurationResponse(
    public val certificateUrl: String? = null,
    public val dnsSuffix: String? = null,
    public val id: String,
    public val keyVaultReferenceIdentity: String? = null,
    public val kind: String? = null,
    public val name: String,
    public val provisioningDetails: String,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.CustomDnsSuffixConfigurationResponse):
            CustomDnsSuffixConfigurationResponse = CustomDnsSuffixConfigurationResponse(
            certificateUrl = javaType.certificateUrl().map({ args0 -> args0 }).orElse(null),
            dnsSuffix = javaType.dnsSuffix().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            keyVaultReferenceIdentity = javaType.keyVaultReferenceIdentity().map({ args0 ->
                args0
            }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningDetails = javaType.provisioningDetails(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
