@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Database backup settings.
 * @property connectionString Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new database, the database name inside is the new one.
 * @property connectionStringName Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
 * This is used during restore with overwrite connection strings options.
 * @property databaseType Database type (e.g. SqlAzure / MySql).
 * @property name
 */
public data class DatabaseBackupSettingResponse(
    public val connectionString: String? = null,
    public val connectionStringName: String? = null,
    public val databaseType: String,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.DatabaseBackupSettingResponse):
            DatabaseBackupSettingResponse = DatabaseBackupSettingResponse(
            connectionString = javaType.connectionString().map({ args0 -> args0 }).orElse(null),
            connectionStringName = javaType.connectionStringName().map({ args0 -> args0 }).orElse(null),
            databaseType = javaType.databaseType(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
