@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Body of the error response returned from the API.
 * @property code Basic error code.
 * @property details Error Details.
 * @property extendedCode Type of error.
 * @property innerErrors Inner errors.
 * @property message Any details of the error.
 * @property messageTemplate Message template.
 * @property parameters Parameters for the template.
 * @property target The error target.
 */
public data class ErrorEntityResponse(
    public val code: String? = null,
    public val details: List<ErrorEntityResponse>? = null,
    public val extendedCode: String? = null,
    public val innerErrors: List<ErrorEntityResponse>? = null,
    public val message: String? = null,
    public val messageTemplate: String? = null,
    public val parameters: List<String>? = null,
    public val target: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ErrorEntityResponse):
            ErrorEntityResponse = ErrorEntityResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ErrorEntityResponse.Companion.toKotlin(args0)
                })
            }),
            extendedCode = javaType.extendedCode().map({ args0 -> args0 }).orElse(null),
            innerErrors = javaType.innerErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ErrorEntityResponse.Companion.toKotlin(args0)
                })
            }),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            messageTemplate = javaType.messageTemplate().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 -> args0 }),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
        )
    }
}
