@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Extended Location.
 * @property name Name of extended location.
 * @property type Type of extended location.
 */
public data class ExtendedLocationResponse(
    public val name: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ExtendedLocationResponse):
            ExtendedLocationResponse = ExtendedLocationResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
