@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A Kubernetes cluster specialized for web workloads by Azure App Service
 * @property aksResourceID
 * @property appLogsConfiguration Cluster configuration which enables the log daemon to export
 * app logs to a destination. Currently only "log-analytics" is
 * supported
 * @property arcConfiguration Cluster configuration which determines the ARC cluster
 * components types. Eg: Choosing between BuildService kind,
 * FrontEnd Service ArtifactsStorageType etc.
 * @property containerAppsConfiguration Cluster configuration for Container Apps Environments to configure Dapr Instrumentation Key and VNET Configuration
 * @property defaultDomain Default Domain Name for the cluster
 * @property deploymentErrors Any errors that occurred during deployment or deployment validation
 * @property environmentType Type of Kubernetes Environment. Only supported for Container App Environments with value as Managed
 * @property extendedLocation Extended Location.
 * @property id Resource Id.
 * @property internalLoadBalancerEnabled Only visible within Vnet/Subnet
 * @property kind Kind of resource.
 * @property location Resource Location.
 * @property name Resource Name.
 * @property provisioningState Provisioning state of the Kubernetes Environment.
 * @property staticIp Static IP of the KubeEnvironment
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetKubeEnvironmentResult(
    public val aksResourceID: String? = null,
    public val appLogsConfiguration: AppLogsConfigurationResponse? = null,
    public val arcConfiguration: ArcConfigurationResponse? = null,
    public val containerAppsConfiguration: ContainerAppsConfigurationResponse? = null,
    public val defaultDomain: String,
    public val deploymentErrors: String,
    public val environmentType: String? = null,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String,
    public val internalLoadBalancerEnabled: Boolean? = null,
    public val kind: String? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val staticIp: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetKubeEnvironmentResult):
            GetKubeEnvironmentResult = GetKubeEnvironmentResult(
            aksResourceID = javaType.aksResourceID().map({ args0 -> args0 }).orElse(null),
            appLogsConfiguration = javaType.appLogsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.AppLogsConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            arcConfiguration = javaType.arcConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ArcConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            containerAppsConfiguration = javaType.containerAppsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ContainerAppsConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defaultDomain = javaType.defaultDomain(),
            deploymentErrors = javaType.deploymentErrors(),
            environmentType = javaType.environmentType().map({ args0 -> args0 }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            internalLoadBalancerEnabled = javaType.internalLoadBalancerEnabled().map({ args0 ->
                args0
            }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            staticIp = javaType.staticIp().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
