@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Static Site Linked Backend ARM resource.
 * @property backendResourceId The resource id of the backend linked to the static site
 * @property createdOn The date and time on which the backend was linked to the static site.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property provisioningState The provisioning state of the linking process.
 * @property region The region of the backend linked to the static site
 * @property type Resource type.
 */
public data class GetStaticSiteLinkedBackendForBuildResult(
    public val backendResourceId: String? = null,
    public val createdOn: String,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val region: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetStaticSiteLinkedBackendForBuildResult):
            GetStaticSiteLinkedBackendForBuildResult = GetStaticSiteLinkedBackendForBuildResult(
            backendResourceId = javaType.backendResourceId().map({ args0 -> args0 }).orElse(null),
            createdOn = javaType.createdOn(),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
