@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Premier add-on.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property location Resource Location.
 * @property marketplaceOffer Premier add on Marketplace offer.
 * @property marketplacePublisher Premier add on Marketplace publisher.
 * @property name Resource Name.
 * @property product Premier add on Product.
 * @property sku Premier add on SKU.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property vendor Premier add on Vendor.
 */
public data class GetWebAppPremierAddOnSlotResult(
    public val id: String,
    public val kind: String? = null,
    public val location: String,
    public val marketplaceOffer: String? = null,
    public val marketplacePublisher: String? = null,
    public val name: String,
    public val product: String? = null,
    public val sku: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vendor: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppPremierAddOnSlotResult):
            GetWebAppPremierAddOnSlotResult = GetWebAppPremierAddOnSlotResult(
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            marketplaceOffer = javaType.marketplaceOffer().map({ args0 -> args0 }).orElse(null),
            marketplacePublisher = javaType.marketplacePublisher().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            product = javaType.product().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vendor = javaType.vendor().map({ args0 -> args0 }).orElse(null),
        )
    }
}
