@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property sendKeyName The name of the send key.
 * @property sendKeyValue The value of the send key.
 * @property type Resource type.
 */
public data class ListAppServicePlanHybridConnectionKeysResult(
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val sendKeyName: String,
    public val sendKeyValue: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ListAppServicePlanHybridConnectionKeysResult):
            ListAppServicePlanHybridConnectionKeysResult = ListAppServicePlanHybridConnectionKeysResult(
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            sendKeyName = javaType.sendKeyName(),
            sendKeyValue = javaType.sendKeyValue(),
            type = javaType.type(),
        )
    }
}
