@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * String list resource.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property properties List of string resources.
 * @property type Resource type.
 */
public data class ListStaticSiteConfiguredRolesResult(
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val properties: List<String>,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ListStaticSiteConfiguredRolesResult):
            ListStaticSiteConfiguredRolesResult = ListStaticSiteConfiguredRolesResult(
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
